/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.nio.ConnectionListenable;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.server.NetworkStats;
import com.hazelcast.internal.server.Server;
import com.hazelcast.internal.server.ServerConnection;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ServerConnectionManager
extends ConnectionListenable<ServerConnection>,
Consumer<Packet> {
    @Nonnull
    public Collection<ServerConnection> getConnections();

    default public int connectionCount(@Nullable Predicate<ServerConnection> predicate) {
        if (predicate == null) {
            return this.getConnections().size();
        }
        return (int)this.getConnections().stream().filter(predicate).count();
    }

    default public boolean register(Address remoteAddress, ServerConnection connection) {
        return this.register(remoteAddress, connection, 0);
    }

    public boolean register(Address var1, ServerConnection var2, int var3);

    default public int connectionCount() {
        return this.connectionCount(null);
    }

    default public ServerConnection get(Address address) {
        return this.get(address, 0);
    }

    public ServerConnection get(Address var1, int var2);

    default public ServerConnection getOrConnect(Address address) {
        return this.getOrConnect(address, false, 0);
    }

    public ServerConnection getOrConnect(Address var1, int var2);

    default public ServerConnection getOrConnect(Address address, boolean silent) {
        return this.getOrConnect(address, silent, 0);
    }

    public ServerConnection getOrConnect(Address var1, boolean var2, int var3);

    default public boolean transmit(Packet packet, Address target) {
        return this.transmit(packet, target, 0);
    }

    public boolean transmit(Packet var1, Address var2, int var3);

    public NetworkStats getNetworkStats();

    public Server getServer();
}

