/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate;

import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.converter.StringConverter;
import java.math.BigDecimal;

public final class SqlNodeUtil {
    private SqlNodeUtil() {
    }

    public static boolean isParameter(SqlNode node) {
        return node.getKind() == SqlKind.DYNAMIC_PARAM;
    }

    public static boolean isLiteral(SqlNode node) {
        return node.getKind() == SqlKind.LITERAL;
    }

    public static Number numericValue(SqlNode node) {
        if (node.getKind() != SqlKind.LITERAL) {
            return null;
        }
        SqlLiteral literal = (SqlLiteral)node;
        SqlTypeName typeName = literal.getTypeName();
        if (SqlTypeName.CHAR_TYPES.contains((Object)typeName)) {
            String value = literal.getValueAs(String.class);
            if (value == null) {
                return null;
            }
            if (value.contains("e") || value.contains("E")) {
                try {
                    return StringConverter.INSTANCE.asDouble(value);
                }
                catch (QueryException e) {
                    assert (e.getCode() == 2000);
                    throw SqlUtil.newContextException(literal.getParserPosition(), Static.RESOURCE.invalidLiteral(literal.toString(), SqlTypeName.DOUBLE.getName()));
                }
            }
            try {
                return StringConverter.INSTANCE.asDecimal(value);
            }
            catch (QueryException e) {
                assert (e.getCode() == 2000);
                throw SqlUtil.newContextException(literal.getParserPosition(), Static.RESOURCE.invalidLiteral(literal.toString(), SqlTypeName.DECIMAL.getName()));
            }
        }
        if (SqlTypeName.APPROX_TYPES.contains((Object)typeName)) {
            return literal.getValueAs(Double.class);
        }
        return SqlTypeName.EXACT_TYPES.contains((Object)typeName) ? (Number)literal.getValueAs(BigDecimal.class) : (Number)null;
    }
}

