/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.SqlRowImpl;
import com.hazelcast.sql.impl.client.SqlClientService;
import com.hazelcast.sql.impl.client.SqlPage;
import com.hazelcast.sql.impl.row.HeapRow;
import com.hazelcast.sql.impl.row.Row;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public class SqlClientResult
implements SqlResult {
    private final SqlClientService service;
    private final Connection connection;
    private final QueryId queryId;
    private final SqlRowMetadata rowMetadata;
    private final ClientIterator iterator;
    private final int cursorBufferSize;
    private final long updateCount;
    private boolean closed;
    private boolean iteratorAccessed;

    public SqlClientResult(SqlClientService service, Connection connection, QueryId queryId, SqlRowMetadata rowMetadata, List<List<Data>> rowPage, boolean rowPageLast, int cursorBufferSize, long updateCount) {
        this.service = service;
        this.connection = connection;
        this.queryId = queryId;
        this.rowMetadata = rowMetadata;
        this.cursorBufferSize = cursorBufferSize;
        this.updateCount = updateCount;
        if (updateCount >= 0L) {
            this.iterator = null;
        } else {
            assert (updateCount == -1L);
            assert (rowMetadata != null);
            this.iterator = new ClientIterator();
            this.iterator.onNextPage(rowPage, rowPageLast);
        }
    }

    @Override
    @Nonnull
    public SqlRowMetadata getRowMetadata() {
        this.checkIsRowsResult();
        assert (this.rowMetadata != null);
        return this.rowMetadata;
    }

    @Override
    @Nonnull
    public Iterator<SqlRow> iterator() {
        if (this.iteratorAccessed) {
            throw new IllegalStateException("Iterator can be requested only once");
        }
        this.checkIsRowsResult();
        this.iteratorAccessed = true;
        return this.iterator;
    }

    @Override
    public long updateCount() {
        return this.updateCount;
    }

    @Override
    public void close() {
        if (this.iterator == null) {
            return;
        }
        try {
            if (!this.closed) {
                if (this.iterator.last) {
                    return;
                }
                this.service.close(this.connection, this.queryId);
            }
        }
        finally {
            this.closed = true;
        }
    }

    private void checkIsRowsResult() {
        if (this.iterator == null) {
            throw new IllegalStateException("This result contains only update count");
        }
    }

    private void fetchNextPage(ClientIterator iterator) {
        SqlPage page = this.service.fetch(this.connection, this.queryId, this.cursorBufferSize);
        iterator.onNextPage(page.getRows(), page.isLast());
    }

    private List<Row> convertPageRows(List<List<Data>> serializedRows) {
        ArrayList<Row> rows = new ArrayList<Row>(serializedRows.size());
        for (List<Data> serializedRow : serializedRows) {
            Object[] values = new Object[serializedRow.size()];
            for (int i = 0; i < serializedRow.size(); ++i) {
                values[i] = this.service.deserializeRowValue(serializedRow.get(i));
            }
            rows.add(new HeapRow(values));
        }
        return rows;
    }

    private class ClientIterator
    implements Iterator<SqlRow> {
        private List<Row> currentRows;
        private int currentPosition;
        private boolean last;

        private ClientIterator() {
        }

        @Override
        public boolean hasNext() {
            if (SqlClientResult.this.closed) {
                throw SqlClientResult.this.service.rethrow(QueryException.cancelledByUser());
            }
            while (this.currentPosition == this.currentRows.size()) {
                if (!this.last) {
                    SqlClientResult.this.fetchNextPage(this);
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public SqlRow next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Row row = this.currentRows.get(this.currentPosition++);
            return new SqlRowImpl(SqlClientResult.this.rowMetadata, row);
        }

        private void onNextPage(List<List<Data>> rowPage, boolean rowPageLast) {
            this.currentRows = SqlClientResult.this.convertPageRows(rowPage);
            this.currentPosition = 0;
            this.last = rowPageLast;
        }
    }
}

