/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.client.SqlError;
import java.util.List;

public final class SqlExecuteResponse {
    private final QueryId queryId;
    private final List<SqlColumnMetadata> rowMetadata;
    private final List<List<Data>> rowPage;
    private final boolean rowPageLast;
    private final SqlError error;
    private final long updateCount;

    private SqlExecuteResponse(QueryId queryId, List<SqlColumnMetadata> rowMetadata, List<List<Data>> rowPage, boolean rowPageLast, long updateCount, SqlError error) {
        this.queryId = queryId;
        this.rowMetadata = rowMetadata;
        this.rowPage = rowPage;
        this.rowPageLast = rowPageLast;
        this.updateCount = updateCount;
        this.error = error;
    }

    public static SqlExecuteResponse rowsResponse(QueryId queryId, List<SqlColumnMetadata> rowMetadata, List<List<Data>> rowPage, boolean rowPageLast) {
        return new SqlExecuteResponse(queryId, rowMetadata, rowPage, rowPageLast, -1L, null);
    }

    public static SqlExecuteResponse errorResponse(SqlError error) {
        return new SqlExecuteResponse(null, null, null, true, -1L, error);
    }

    public static SqlExecuteResponse updateCountResponse(long updateCount) {
        Preconditions.checkNotNegative(updateCount, "the updateCount must be >= 0");
        return new SqlExecuteResponse(null, null, null, true, updateCount, null);
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public List<SqlColumnMetadata> getRowMetadata() {
        return this.rowMetadata;
    }

    public List<List<Data>> getRowPage() {
        return this.rowPage;
    }

    public boolean isRowPageLast() {
        return this.rowPageLast;
    }

    public SqlError getError() {
        return this.error;
    }

    public long getUpdateCount() {
        return this.updateCount;
    }
}

