/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config.override;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class EnvVariablesConfigParser {
    private static final List<String> EXCLUDED_ENTRIES = Arrays.asList("HZ_HOME", "HZ_LICENSE_KEY", "HZ_PHONE_HOME_ENABLED");
    private final String prefix;
    private final String rootNode;

    EnvVariablesConfigParser(String prefix, String rootNode) {
        this.prefix = prefix;
        this.rootNode = rootNode;
    }

    static EnvVariablesConfigParser client() {
        return new EnvVariablesConfigParser("HZCLIENT_", "hazelcast-client");
    }

    static EnvVariablesConfigParser member() {
        return new EnvVariablesConfigParser("HZ_", "hazelcast");
    }

    Map<String, String> parse(Map<String, String> env) {
        return env.entrySet().stream().filter(e -> !EXCLUDED_ENTRIES.contains(((String)e.getKey()).replace(" ", ""))).filter(e -> ((String)e.getKey()).startsWith(this.prefix)).collect(Collectors.toMap(this::processKey, Map.Entry::getValue));
    }

    private String processKey(Map.Entry<String, String> e) {
        return e.getKey().replaceFirst(this.prefix, this.rootNode + ".").replace("_", ".").replace(" ", "").toLowerCase();
    }
}

