/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.PartitionDataSerializerHook;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class PartitionRuntimeState
implements IdentifiedDataSerializable,
Versioned {
    private PartitionReplica[] allReplicas;
    private int[][] encodedPartitionTable;
    private int[] versions;
    private long stamp;
    private int version;
    private Collection<MigrationInfo> completedMigrations;
    private Collection<MigrationInfo> activeMigrations;
    private transient Address master;

    public PartitionRuntimeState() {
    }

    public PartitionRuntimeState(InternalPartition[] partitions, Collection<MigrationInfo> completedMigrations, long stamp) {
        this(partitions, completedMigrations, stamp, 0);
    }

    @Deprecated
    public PartitionRuntimeState(InternalPartition[] partitions, Collection<MigrationInfo> completedMigrations, int version) {
        this(partitions, completedMigrations, 0L, version);
    }

    private PartitionRuntimeState(InternalPartition[] partitions, Collection<MigrationInfo> completedMigrations, long stamp, int version) {
        this.stamp = stamp;
        this.version = version;
        this.completedMigrations = completedMigrations != null ? completedMigrations : Collections.emptyList();
        Map<PartitionReplica, Integer> replicaToIndexes = PartitionRuntimeState.createPartitionReplicaToIndexMap(partitions);
        this.allReplicas = this.toPartitionReplicaArray(replicaToIndexes);
        this.encodePartitionTable(partitions, replicaToIndexes);
    }

    private PartitionReplica[] toPartitionReplicaArray(Map<PartitionReplica, Integer> addressToIndexes) {
        PartitionReplica[] replicas = new PartitionReplica[addressToIndexes.size()];
        for (Map.Entry<PartitionReplica, Integer> entry : addressToIndexes.entrySet()) {
            replicas[entry.getValue().intValue()] = entry.getKey();
        }
        return replicas;
    }

    private void encodePartitionTable(InternalPartition[] partitions, Map<PartitionReplica, Integer> replicaToIndexes) {
        this.versions = new int[partitions.length];
        this.encodedPartitionTable = new int[partitions.length][7];
        for (InternalPartition partition : partitions) {
            int[] indexes = this.encodedPartitionTable[partition.getPartitionId()];
            this.versions[partition.getPartitionId()] = partition.version();
            for (int replicaIndex = 0; replicaIndex < 7; ++replicaIndex) {
                int index;
                PartitionReplica replica = partition.getReplica(replicaIndex);
                indexes[replicaIndex] = replica == null ? -1 : (index = replicaToIndexes.get(replica).intValue());
            }
        }
    }

    private static Map<PartitionReplica, Integer> createPartitionReplicaToIndexMap(InternalPartition[] partitions) {
        HashMap<PartitionReplica, Integer> map = new HashMap<PartitionReplica, Integer>();
        int addressIndex = 0;
        for (InternalPartition partition : partitions) {
            for (int i = 0; i < 7; ++i) {
                PartitionReplica replica = partition.getReplica(i);
                if (replica == null || map.containsKey(replica)) continue;
                map.put(replica, addressIndex++);
            }
        }
        return map;
    }

    public InternalPartition[] getPartitions() {
        int length = this.encodedPartitionTable.length;
        InternalPartition[] result = new InternalPartition[length];
        for (int partitionId = 0; partitionId < length; ++partitionId) {
            int[] addressIndexes = this.encodedPartitionTable[partitionId];
            PartitionReplica[] replicas = new PartitionReplica[7];
            for (int replicaIndex = 0; replicaIndex < addressIndexes.length; ++replicaIndex) {
                int index = addressIndexes[replicaIndex];
                if (index == -1) continue;
                PartitionReplica replica = this.allReplicas[index];
                assert (replica != null);
                replicas[replicaIndex] = replica;
            }
            result[partitionId] = new InternalPartitionImpl(partitionId, null, replicas, this.versions[partitionId], null);
        }
        return result;
    }

    @Deprecated
    public PartitionReplica[][] getPartitionTable() {
        int length = this.encodedPartitionTable.length;
        PartitionReplica[][] result = new PartitionReplica[length][7];
        for (int partitionId = 0; partitionId < length; ++partitionId) {
            int[] addressIndexes = this.encodedPartitionTable[partitionId];
            for (int replicaIndex = 0; replicaIndex < addressIndexes.length; ++replicaIndex) {
                int index = addressIndexes[replicaIndex];
                if (index == -1) continue;
                PartitionReplica replica = this.allReplicas[index];
                assert (replica != null);
                result[partitionId][replicaIndex] = replica;
            }
        }
        return result;
    }

    public Address getMaster() {
        return this.master;
    }

    public void setMaster(Address master) {
        this.master = master;
    }

    public Collection<MigrationInfo> getCompletedMigrations() {
        return this.completedMigrations != null ? this.completedMigrations : Collections.emptyList();
    }

    public Collection<MigrationInfo> getActiveMigrations() {
        return this.activeMigrations;
    }

    public void setActiveMigrations(Collection<MigrationInfo> activeMigrations) {
        this.activeMigrations = activeMigrations;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int i;
        Version clusterVersion = in.getVersion();
        if (clusterVersion.isGreaterOrEqual(Versions.V4_1)) {
            this.stamp = in.readLong();
        } else {
            this.version = in.readInt();
        }
        int memberCount = in.readInt();
        this.allReplicas = new PartitionReplica[memberCount];
        for (int i2 = 0; i2 < memberCount; ++i2) {
            PartitionReplica replica = (PartitionReplica)in.readObject();
            int index = in.readInt();
            assert (this.allReplicas[index] == null) : "Duplicate replica! Member: " + replica + ", index: " + index + ", addresses: " + Arrays.toString(this.allReplicas);
            this.allReplicas[index] = replica;
        }
        int partitionCount = in.readInt();
        this.encodedPartitionTable = new int[partitionCount][7];
        this.versions = new int[partitionCount];
        for (i = 0; i < partitionCount; ++i) {
            int[] indexes = this.encodedPartitionTable[i];
            for (int ix = 0; ix < 7; ++ix) {
                indexes[ix] = in.readInt();
            }
        }
        if (clusterVersion.isGreaterOrEqual(Versions.V4_1)) {
            for (i = 0; i < partitionCount; ++i) {
                this.versions[i] = in.readInt();
            }
            this.activeMigrations = SerializationUtil.readNullableCollection(in);
        } else {
            MigrationInfo activeMigration = (MigrationInfo)in.readObject();
            if (activeMigration != null) {
                this.activeMigrations = Collections.singleton(activeMigration);
            }
        }
        this.completedMigrations = SerializationUtil.readNullableCollection(in);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        void var3_4;
        Version clusterVersion = out.getVersion();
        if (clusterVersion.isGreaterOrEqual(Versions.V4_1)) {
            out.writeLong(this.stamp);
        } else {
            out.writeInt(this.version);
        }
        out.writeInt(this.allReplicas.length);
        boolean bl = false;
        while (var3_4 < this.allReplicas.length) {
            PartitionReplica replica = this.allReplicas[var3_4];
            out.writeObject(replica);
            out.writeInt((int)var3_4);
            ++var3_4;
        }
        out.writeInt(this.encodedPartitionTable.length);
        for (int[] indexes : this.encodedPartitionTable) {
            for (int ix = 0; ix < 7; ++ix) {
                out.writeInt(indexes[ix]);
            }
        }
        if (clusterVersion.isGreaterOrEqual(Versions.V4_1)) {
            for (int v : this.versions) {
                out.writeInt(v);
            }
            SerializationUtil.writeNullableCollection(this.activeMigrations, out);
        } else {
            void var3_9;
            if (this.activeMigrations == null || this.activeMigrations.isEmpty()) {
                Object var3_7 = null;
            } else {
                assert (this.activeMigrations.size() == 1) : "Active migrations should be singleton: " + this.activeMigrations;
                MigrationInfo migrationInfo = this.activeMigrations.iterator().next();
            }
            out.writeObject(var3_9);
        }
        SerializationUtil.writeNullableCollection(this.completedMigrations, out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionRuntimeState [" + this.stamp + "]{" + StringUtil.LINE_SEPARATOR);
        for (PartitionReplica replica : this.allReplicas) {
            sb.append(replica).append(StringUtil.LINE_SEPARATOR);
        }
        sb.append(", completedMigrations=").append(this.completedMigrations);
        sb.append('}');
        return sb.toString();
    }

    public long getStamp() {
        return this.stamp;
    }

    @Deprecated
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getFactoryId() {
        return PartitionDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }
}

