/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.metadata;

import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.metadata.BuiltInMetadata;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataDef;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataHandler;
import com.hazelcast.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.util.BuiltInMethod;

public class RelMdMemory
implements MetadataHandler<BuiltInMetadata.Memory> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((MetadataHandler)new RelMdMemory(), BuiltInMethod.MEMORY.method, BuiltInMethod.CUMULATIVE_MEMORY_WITHIN_PHASE.method, BuiltInMethod.CUMULATIVE_MEMORY_WITHIN_PHASE_SPLIT.method);

    protected RelMdMemory() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.Memory> getDef() {
        return BuiltInMetadata.Memory.DEF;
    }

    public Double memory(RelNode rel, RelMetadataQuery mq) {
        return null;
    }

    public Double cumulativeMemoryWithinPhase(RelNode rel, RelMetadataQuery mq) {
        Double nullable = mq.memory(rel);
        if (nullable == null) {
            return null;
        }
        Boolean isPhaseTransition = mq.isPhaseTransition(rel);
        if (isPhaseTransition == null) {
            return null;
        }
        double d = nullable;
        if (!isPhaseTransition.booleanValue()) {
            for (RelNode input : rel.getInputs()) {
                nullable = mq.cumulativeMemoryWithinPhase(input);
                if (nullable == null) {
                    return null;
                }
                d += nullable.doubleValue();
            }
        }
        return d;
    }

    public Double cumulativeMemoryWithinPhaseSplit(RelNode rel, RelMetadataQuery mq) {
        Double memoryWithinPhase = mq.cumulativeMemoryWithinPhase(rel);
        Integer splitCount = mq.splitCount(rel);
        if (memoryWithinPhase == null || splitCount == null) {
            return null;
        }
        return memoryWithinPhase / (double)splitCount.intValue();
    }
}

