/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.util.graph;

import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.apache.calcite.util.graph.DefaultDirectedGraph;
import com.hazelcast.org.apache.calcite.util.graph.DefaultEdge;
import com.hazelcast.org.apache.calcite.util.graph.DirectedGraph;
import java.util.List;

public class AttributedDirectedGraph<V, E extends DefaultEdge>
extends DefaultDirectedGraph<V, E> {
    public AttributedDirectedGraph(AttributedEdgeFactory<V, E> edgeFactory) {
        super(edgeFactory);
    }

    public static <V, E extends DefaultEdge> AttributedDirectedGraph<V, E> create(AttributedEdgeFactory<V, E> edgeFactory) {
        return new AttributedDirectedGraph<V, E>(edgeFactory);
    }

    @Override
    public E getEdge(V source, V target) {
        DefaultDirectedGraph.VertexInfo info = (DefaultDirectedGraph.VertexInfo)this.vertexMap.get(source);
        for (DefaultEdge outEdge : info.outEdges) {
            if (!outEdge.target.equals(target)) continue;
            return (E)outEdge;
        }
        return null;
    }

    @Override
    @Deprecated
    public E addEdge(V vertex, V targetVertex) {
        return (E)super.addEdge((Object)vertex, (Object)targetVertex);
    }

    public E addEdge(V vertex, V targetVertex, Object ... attributes) {
        DefaultDirectedGraph.VertexInfo info = (DefaultDirectedGraph.VertexInfo)this.vertexMap.get(vertex);
        if (info == null) {
            throw new IllegalArgumentException("no vertex " + vertex);
        }
        DefaultDirectedGraph.VertexInfo targetInfo = (DefaultDirectedGraph.VertexInfo)this.vertexMap.get(targetVertex);
        if (targetInfo == null) {
            throw new IllegalArgumentException("no vertex " + targetVertex);
        }
        AttributedEdgeFactory f = (AttributedEdgeFactory)this.edgeFactory;
        DefaultEdge edge = (DefaultEdge)f.createEdge(vertex, targetVertex, attributes);
        if (this.edges.add(edge)) {
            info.outEdges.add(edge);
            targetInfo.inEdges.add(edge);
            return (E)edge;
        }
        return null;
    }

    public Iterable<E> getEdges(V source, V target) {
        DefaultDirectedGraph.VertexInfo info = (DefaultDirectedGraph.VertexInfo)this.vertexMap.get(source);
        return Util.filter(info.outEdges, outEdge -> outEdge.target.equals(target));
    }

    @Override
    public boolean removeEdge(V source, V target) {
        List outEdges = ((DefaultDirectedGraph.VertexInfo)this.vertexMap.get(source)).outEdges;
        int removeOutCount = 0;
        int size = outEdges.size();
        for (int i = 0; i < size; ++i) {
            DefaultEdge edge = (DefaultEdge)outEdges.get(i);
            if (!edge.target.equals(target)) continue;
            outEdges.remove(i);
            this.edges.remove(edge);
            ++removeOutCount;
        }
        List inEdges = ((DefaultDirectedGraph.VertexInfo)this.vertexMap.get(target)).inEdges;
        int removeInCount = 0;
        int size2 = inEdges.size();
        for (int i = 0; i < size2; ++i) {
            DefaultEdge edge = (DefaultEdge)inEdges.get(i);
            if (!edge.source.equals(source)) continue;
            inEdges.remove(i);
            ++removeInCount;
        }
        assert (removeOutCount == removeInCount);
        return removeOutCount > 0;
    }

    public static interface AttributedEdgeFactory<V, E>
    extends DirectedGraph.EdgeFactory<V, E> {
        public E createEdge(V var1, V var2, Object ... var3);
    }
}

