/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.node;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.plan.node.ZeroInputPlanNode;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractMapScanPlanNode
extends ZeroInputPlanNode {
    protected String mapName;
    protected QueryTargetDescriptor keyDescriptor;
    protected QueryTargetDescriptor valueDescriptor;
    protected List<QueryPath> fieldPaths;
    protected List<QueryDataType> fieldTypes;
    protected List<Integer> projects;
    protected Expression<Boolean> filter;

    protected AbstractMapScanPlanNode() {
    }

    protected AbstractMapScanPlanNode(int id, String mapName, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, List<QueryPath> fieldPaths, List<QueryDataType> fieldTypes, List<Integer> projects, Expression<Boolean> filter) {
        super(id);
        this.mapName = mapName;
        this.keyDescriptor = keyDescriptor;
        this.valueDescriptor = valueDescriptor;
        this.fieldPaths = fieldPaths;
        this.fieldTypes = fieldTypes;
        this.projects = projects;
        this.filter = filter;
    }

    public String getMapName() {
        return this.mapName;
    }

    public QueryTargetDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    public QueryTargetDescriptor getValueDescriptor() {
        return this.valueDescriptor;
    }

    public List<QueryPath> getFieldPaths() {
        return this.fieldPaths;
    }

    public List<QueryDataType> getFieldTypes() {
        return this.fieldTypes;
    }

    public List<Integer> getProjects() {
        return this.projects;
    }

    public Expression<Boolean> getFilter() {
        return this.filter;
    }

    @Override
    public PlanNodeSchema getSchema0() {
        ArrayList<QueryDataType> types = new ArrayList<QueryDataType>(this.projects.size());
        for (Integer project : this.projects) {
            types.add(this.fieldTypes.get(project));
        }
        return new PlanNodeSchema(types);
    }

    @Override
    protected void writeData0(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        out.writeObject(this.keyDescriptor);
        out.writeObject(this.valueDescriptor);
        SerializationUtil.writeList(this.fieldPaths, out);
        SerializationUtil.writeList(this.fieldTypes, out);
        SerializationUtil.writeList(this.projects, out);
        out.writeObject(this.filter);
    }

    @Override
    protected void readData0(ObjectDataInput in) throws IOException {
        this.mapName = in.readUTF();
        this.keyDescriptor = (QueryTargetDescriptor)in.readObject();
        this.valueDescriptor = (QueryTargetDescriptor)in.readObject();
        this.fieldPaths = SerializationUtil.readList(in);
        this.fieldTypes = SerializationUtil.readList(in);
        this.projects = SerializationUtil.readList(in);
        this.filter = (Expression)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMapScanPlanNode that = (AbstractMapScanPlanNode)o;
        return this.id == that.id && this.mapName.equals(that.mapName) && this.keyDescriptor.equals(that.keyDescriptor) && this.valueDescriptor.equals(that.valueDescriptor) && this.fieldPaths.equals(that.fieldPaths) && this.fieldTypes.equals(that.fieldTypes) && this.projects.equals(that.projects) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.id);
        result = 31 * result + this.mapName.hashCode();
        result = 31 * result + this.keyDescriptor.hashCode();
        result = 31 * result + this.valueDescriptor.hashCode();
        result = 31 * result + this.fieldPaths.hashCode();
        result = 31 * result + this.fieldTypes.hashCode();
        result = 31 * result + this.projects.hashCode();
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        return result;
    }
}

