/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.worker;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.worker.QueryFragmentExecutable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;

public class QueryFragmentWorkerPool {
    private final ForkJoinPool pool;
    private final ILogger logger;

    public QueryFragmentWorkerPool(String instanceName, int threadCount, ILogger logger) {
        this.pool = new ForkJoinPool(threadCount, new WorkerThreadFactory(instanceName), new ExceptionHandler(), true);
        this.logger = logger;
    }

    public void stop() {
        this.pool.shutdownNow();
    }

    public void submit(QueryFragmentExecutable task) {
        this.pool.execute(task::run);
    }

    private class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable t) {
            OutOfMemoryErrorDispatcher.inspectOutOfMemoryError(t);
            QueryFragmentWorkerPool.this.logger.severe(t);
        }
    }

    private static final class WorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final String instanceName;
        private final AtomicLong indexGenerator = new AtomicLong();

        private WorkerThreadFactory(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            String name = QueryUtils.workerName(this.instanceName, "query-fragment-thread", this.indexGenerator.incrementAndGet());
            WorkerThread thread = new WorkerThread(pool);
            thread.setName(name);
            return thread;
        }
    }

    private static final class WorkerThread
    extends ForkJoinWorkerThread {
        private WorkerThread(ForkJoinPool pool) {
            super(pool);
        }
    }
}

