/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.worker;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.concurrent.MPSCQueue;
import com.hazelcast.logging.ILogger;
import com.hazelcast.sql.impl.LocalMemberIdProvider;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.operation.QueryCancelOperation;
import com.hazelcast.sql.impl.operation.QueryOperation;
import com.hazelcast.sql.impl.operation.QueryOperationDeserializationException;
import com.hazelcast.sql.impl.operation.QueryOperationHandler;
import com.hazelcast.sql.impl.worker.QueryOperationExecutable;
import java.util.UUID;

public class QueryOperationWorker
implements Runnable {
    private static final Object POISON = new Object();
    private final LocalMemberIdProvider localMemberIdProvider;
    private final QueryOperationHandler operationHandler;
    private final SerializationService ss;
    private final Thread thread;
    private final MPSCQueue<Object> queue;
    private final ILogger logger;

    public QueryOperationWorker(LocalMemberIdProvider localMemberIdProvider, QueryOperationHandler operationHandler, SerializationService ss, String instanceName, int index, ILogger logger) {
        this.localMemberIdProvider = localMemberIdProvider;
        this.operationHandler = operationHandler;
        this.ss = ss;
        this.logger = logger;
        this.thread = new Thread((Runnable)this, QueryUtils.workerName(instanceName, "query-operation-thread", index));
        this.queue = new MPSCQueue(this.thread, null);
        this.thread.start();
    }

    public void submit(QueryOperationExecutable task) {
        this.queue.add(task);
    }

    public void stop() {
        this.queue.clear();
        this.queue.add(POISON);
        this.thread.interrupt();
    }

    @Override
    public void run() {
        try {
            this.run0();
        }
        catch (Throwable t) {
            OutOfMemoryErrorDispatcher.inspectOutOfMemoryError(t);
            this.logger.severe(t);
        }
    }

    private void run0() {
        try {
            Object task;
            while ((task = this.queue.take()) != POISON) {
                assert (task instanceof QueryOperationExecutable);
                this.execute((QueryOperationExecutable)task);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void execute(QueryOperationExecutable task) {
        QueryOperation operation;
        if (task.isLocal()) {
            operation = task.getLocalOperation();
        } else {
            operation = this.deserialize(task.getRemoteOperation());
            if (operation == null) {
                return;
            }
        }
        assert (operation != null);
        this.operationHandler.execute(operation);
    }

    private QueryOperation deserialize(Packet packet) {
        try {
            return (QueryOperation)this.ss.toObject(packet);
        }
        catch (Exception e) {
            if (e.getCause() instanceof QueryOperationDeserializationException) {
                QueryOperationDeserializationException error = (QueryOperationDeserializationException)e.getCause();
                this.sendDeserializationError(error);
            } else {
                this.logger.severe("Failed to deserialize query operation received from " + packet.getConn().getRemoteAddress() + " (will be ignored)", e);
            }
            return null;
        }
    }

    private void sendDeserializationError(QueryOperationDeserializationException e) {
        QueryId queryId = e.getQueryId();
        UUID localMemberId = this.localMemberIdProvider.getLocalMemberId();
        UUID targetMemberId = e.getCallerId();
        UUID initiatorMemberId = queryId.getMemberId();
        QueryCancelOperation cancelOperation = new QueryCancelOperation(queryId, -1, "Failed to deserialize " + e.getOperationClassName() + " received from " + targetMemberId + ": " + e.getMessage(), localMemberId);
        this.operationHandler.submit(localMemberId, initiatorMemberId, cancelOperation);
    }

    boolean isThreadTerminated() {
        return this.thread.getState() == Thread.State.TERMINATED;
    }
}

