/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.ClientLockReferenceIdGenerator;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerToKeyWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddIndexCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddInterceptorCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapAggregateCodec;
import com.hazelcast.client.impl.protocol.codec.MapAggregateWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapClearCodec;
import com.hazelcast.client.impl.protocol.codec.MapContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapContainsValueCodec;
import com.hazelcast.client.impl.protocol.codec.MapDeleteCodec;
import com.hazelcast.client.impl.protocol.codec.MapEntriesWithPagingPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapEntriesWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapEntrySetCodec;
import com.hazelcast.client.impl.protocol.codec.MapEventJournalReadCodec;
import com.hazelcast.client.impl.protocol.codec.MapEventJournalSubscribeCodec;
import com.hazelcast.client.impl.protocol.codec.MapEvictAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapEvictCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnAllKeysCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnKeysCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapFlushCodec;
import com.hazelcast.client.impl.protocol.codec.MapForceUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetEntryViewCodec;
import com.hazelcast.client.impl.protocol.codec.MapIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.MapIsLockedCodec;
import com.hazelcast.client.impl.protocol.codec.MapKeySetCodec;
import com.hazelcast.client.impl.protocol.codec.MapKeySetWithPagingPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapKeySetWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapLoadAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapLoadGivenKeysCodec;
import com.hazelcast.client.impl.protocol.codec.MapLockCodec;
import com.hazelcast.client.impl.protocol.codec.MapProjectCodec;
import com.hazelcast.client.impl.protocol.codec.MapProjectWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutIfAbsentCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutIfAbsentWithMaxIdleCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutTransientCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutTransientWithMaxIdleCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutWithMaxIdleCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveIfSameCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveInterceptorCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemovePartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapReplaceCodec;
import com.hazelcast.client.impl.protocol.codec.MapReplaceIfSameCodec;
import com.hazelcast.client.impl.protocol.codec.MapSetCodec;
import com.hazelcast.client.impl.protocol.codec.MapSetTtlCodec;
import com.hazelcast.client.impl.protocol.codec.MapSetWithMaxIdleCodec;
import com.hazelcast.client.impl.protocol.codec.MapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.MapSubmitToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapTryLockCodec;
import com.hazelcast.client.impl.protocol.codec.MapTryPutCodec;
import com.hazelcast.client.impl.protocol.codec.MapTryRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MapUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MapValuesCodec;
import com.hazelcast.client.impl.protocol.codec.MapValuesWithPagingPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapValuesWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.holder.PagingPredicateHolder;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.map.impl.iterator.ClientMapPartitionIterator;
import com.hazelcast.client.map.impl.iterator.ClientMapQueryPartitionIterator;
import com.hazelcast.client.map.impl.querycache.ClientQueryCacheContext;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ReadOnly;
import com.hazelcast.internal.journal.EventJournalInitialSubscriberState;
import com.hazelcast.internal.journal.EventJournalReader;
import com.hazelcast.internal.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.IterationType;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.TimeUtil;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.EventJournalMapEvent;
import com.hazelcast.map.IMap;
import com.hazelcast.map.IMapEvent;
import com.hazelcast.map.LocalMapStats;
import com.hazelcast.map.MapEvent;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapPartitionLostEvent;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapters;
import com.hazelcast.map.impl.MapListenerFlagOperator;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheEndToEndProvider;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequest;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.IndexUtils;
import com.hazelcast.query.impl.predicates.PagingPredicateImpl;
import com.hazelcast.query.impl.predicates.PredicateUtils;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.impl.ReadResultSetImpl;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import com.hazelcast.spi.impl.UnmodifiableLazySet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClientMapProxy<K, V>
extends ClientProxy
implements IMap<K, V>,
EventJournalReader<EventJournalMapEvent<K, V>> {
    protected static final String NULL_LISTENER_IS_NOT_ALLOWED = "Null listener is not allowed!";
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    protected static final String NULL_PREDICATE_IS_NOT_ALLOWED = "Predicate should not be null!";
    protected static final String NULL_AGGREGATOR_IS_NOT_ALLOWED = "Aggregator should not be null!";
    protected static final String NULL_PROJECTION_IS_NOT_ALLOWED = "Projection should not be null!";
    protected static final String NULL_ENTRY_PROCESSOR_IS_NOT_ALLOWED = "Null entry processor is not allowed!";
    protected static final String NULL_TTL_UNIT_IS_NOT_ALLOWED = "Null ttlUnit is not allowed!";
    protected static final String NULL_MAX_IDLE_UNIT_IS_NOT_ALLOWED = "Null maxIdleUnit is not allowed!";
    protected static final String NULL_TIMEUNIT_IS_NOT_ALLOWED = "Null timeunit is not allowed!";
    protected static final String NULL_BIFUNCTION_IS_NOT_ALLOWED = "Null BiFunction is not allowed!";
    protected static final String NULL_FUNCTION_IS_NOT_ALLOWED = "Null Function is not allowed!";
    private ClientLockReferenceIdGenerator lockReferenceIdGenerator;
    private ClientQueryCacheContext queryCacheContext;

    public ClientMapProxy(String serviceName, String name, ClientContext context) {
        super(serviceName, name, context);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.lockReferenceIdGenerator = this.getClient().getLockReferenceIdGenerator();
        this.queryCacheContext = this.getContext().getQueryCacheContext();
    }

    @Override
    public boolean containsKey(@Nonnull Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        return this.containsKeyInternal(key);
    }

    protected boolean containsKeyInternal(Object key) {
        Data keyData = this.toData(key);
        ClientMessage message = MapContainsKeyCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage result = (ClientMessage)this.invoke(message, keyData);
        return MapContainsKeyCodec.decodeResponse(result);
    }

    @Override
    public boolean containsValue(@Nonnull Object value) {
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        ClientMessage request = MapContainsValueCodec.encodeRequest(this.name, valueData);
        ClientMessage response = (ClientMessage)this.invoke(request);
        return MapContainsValueCodec.decodeResponse(response);
    }

    @Override
    public V get(@Nonnull Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        return (V)this.toObject(this.getInternal(key));
    }

    protected Object getInternal(Object key) {
        Data keyData = this.toData(key);
        ClientMessage request = MapGetCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return MapGetCodec.decodeResponse(response);
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        return this.putInternal(-1L, TimeUnit.MILLISECONDS, null, null, key, value);
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit ttlUnit, long maxIdle, @Nonnull TimeUnit maxIdleUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(ttlUnit, NULL_TTL_UNIT_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(maxIdleUnit, NULL_MAX_IDLE_UNIT_IS_NOT_ALLOWED);
        return this.putInternal(ttl, ttlUnit, maxIdle, maxIdleUnit, key, value);
    }

    @Override
    public V remove(@Nonnull Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        return (V)this.toObject(this.removeInternal(key));
    }

    protected Data removeInternal(Object key) {
        Data keyData = this.toData(key);
        ClientMessage request = MapRemoveCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return MapRemoveCodec.decodeResponse(response);
    }

    @Override
    public boolean remove(@Nonnull Object key, @Nonnull Object value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        return this.removeInternal(key, value);
    }

    protected boolean removeInternal(Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MapRemoveIfSameCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return MapRemoveIfSameCodec.decodeResponse(response);
    }

    @Override
    public void removeAll(@Nonnull Predicate<K, V> predicate) {
        Preconditions.checkNotNull(predicate, "predicate cannot be null");
        this.removeAllInternal(predicate);
    }

    protected void removeAllInternal(Predicate predicate) {
        ClientMessage request = MapRemoveAllCodec.encodeRequest(this.name, this.toData(predicate));
        this.invokeWithPredicate(request, predicate);
    }

    @Override
    public void delete(@Nonnull Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        this.deleteInternal(key);
    }

    protected void deleteInternal(Object key) {
        Data keyData = this.toData(key);
        ClientMessage request = MapDeleteCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke(request, keyData);
    }

    @Override
    public void flush() {
        ClientMessage request = MapFlushCodec.encodeRequest(this.name);
        this.invoke(request);
    }

    @Override
    public InternalCompletableFuture<V> getAsync(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        return new ClientDelegatingFuture(this.getAsyncInternal(key), this.getSerializationService(), MapGetCodec::decodeResponse);
    }

    protected ClientInvocationFuture getAsyncInternal(Object key) {
        try {
            Data keyData = this.toData(key);
            ClientMessage request = MapGetCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
            return this.invokeOnKeyOwner(request, keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private ClientInvocationFuture invokeOnKeyOwner(ClientMessage request, Data keyData) {
        int partitionId = this.getContext().getPartitionService().getPartitionId(keyData);
        ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), request, (Object)this.getName(), partitionId);
        return clientInvocation.invoke();
    }

    @Override
    public InternalCompletableFuture<V> putAsync(@Nonnull K key, @Nonnull V value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        return this.putAsyncInternal(-1L, TimeUnit.MILLISECONDS, null, null, key, value);
    }

    @Override
    public InternalCompletableFuture<V> putAsync(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(timeunit, NULL_TIMEUNIT_IS_NOT_ALLOWED);
        return this.putAsyncInternal(ttl, timeunit, null, null, key, value);
    }

    @Override
    public InternalCompletableFuture<V> putAsync(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit ttlUnit, long maxIdle, @Nonnull TimeUnit maxIdleUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(ttlUnit, NULL_TTL_UNIT_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(maxIdleUnit, NULL_MAX_IDLE_UNIT_IS_NOT_ALLOWED);
        return this.putAsyncInternal(ttl, ttlUnit, maxIdle, maxIdleUnit, key, value);
    }

    protected InternalCompletableFuture<V> putAsyncInternal(long ttl, TimeUnit timeunit, Long maxIdle, TimeUnit maxIdleUnit, Object key, Object value) {
        try {
            Data keyData = this.toData(key);
            Data valueData = this.toData(value);
            long ttlMillis = TimeUtil.timeInMsOrOneIfResultIsZero(ttl, timeunit);
            ClientMessage request = maxIdle != null ? MapPutWithMaxIdleCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), ttlMillis, TimeUtil.timeInMsOrOneIfResultIsZero(maxIdle, maxIdleUnit)) : MapPutCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), ttlMillis);
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            SerializationService ss = this.getSerializationService();
            return new ClientDelegatingFuture(future, ss, MapPutCodec::decodeResponse);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public InternalCompletableFuture<Void> setAsync(@Nonnull K key, @Nonnull V value) {
        return this.setAsync((Object)key, (Object)value, -1L, TimeUnit.MILLISECONDS);
    }

    public InternalCompletableFuture<Void> setAsync(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(timeunit, NULL_TIMEUNIT_IS_NOT_ALLOWED);
        return this.setAsyncInternal(ttl, timeunit, null, null, key, value);
    }

    public InternalCompletableFuture<Void> setAsync(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit ttlUnit, long maxIdle, @Nonnull TimeUnit maxIdleUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(ttlUnit, NULL_TTL_UNIT_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(maxIdleUnit, NULL_MAX_IDLE_UNIT_IS_NOT_ALLOWED);
        return this.setAsyncInternal(ttl, ttlUnit, maxIdle, maxIdleUnit, key, value);
    }

    protected InternalCompletableFuture<Void> setAsyncInternal(long ttl, TimeUnit timeunit, Long maxIdle, TimeUnit maxIdleUnit, Object key, Object value) {
        try {
            Data keyData = this.toData(key);
            Data valueData = this.toData(value);
            long ttlMillis = TimeUtil.timeInMsOrOneIfResultIsZero(ttl, timeunit);
            ClientMessage request = maxIdle != null ? MapSetWithMaxIdleCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), ttlMillis, TimeUtil.timeInMsOrOneIfResultIsZero(maxIdle, maxIdleUnit)) : MapSetCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), ttlMillis);
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture<Void>(future, this.getSerializationService(), clientMessage -> null);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public InternalCompletableFuture<V> removeAsync(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        return this.removeAsyncInternal(key);
    }

    protected InternalCompletableFuture<V> removeAsyncInternal(Object key) {
        try {
            Data keyData = this.toData(key);
            ClientMessage request = MapRemoveCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            SerializationService ss = this.getSerializationService();
            return new ClientDelegatingFuture(future, ss, MapRemoveCodec::decodeResponse);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public boolean tryRemove(@Nonnull K key, long timeout, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(timeunit, NULL_TIMEUNIT_IS_NOT_ALLOWED);
        return this.tryRemoveInternal(timeout, timeunit, key);
    }

    protected boolean tryRemoveInternal(long timeout, TimeUnit timeunit, Object key) {
        Data keyData = this.toData(key);
        ClientMessage request = MapTryRemoveCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId(), timeunit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return MapTryRemoveCodec.decodeResponse(response);
    }

    @Override
    public boolean tryPut(@Nonnull K key, @Nonnull V value, long timeout, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(timeunit, NULL_TIMEUNIT_IS_NOT_ALLOWED);
        return this.tryPutInternal(timeout, timeunit, key, value);
    }

    protected boolean tryPutInternal(long timeout, TimeUnit timeunit, Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        long timeoutMillis = TimeUtil.timeInMsOrOneIfResultIsZero(timeout, timeunit);
        ClientMessage request = MapTryPutCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), timeoutMillis);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return MapTryPutCodec.decodeResponse(response);
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(timeunit, NULL_TIMEUNIT_IS_NOT_ALLOWED);
        return this.putInternal(ttl, timeunit, null, null, key, value);
    }

    protected V putInternal(long ttl, TimeUnit ttlUnit, Long maxIdle, TimeUnit maxIdleUnit, Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        long ttlMillis = TimeUtil.timeInMsOrOneIfResultIsZero(ttl, ttlUnit);
        ClientMessage request = maxIdle != null ? MapPutWithMaxIdleCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), ttlMillis, TimeUtil.timeInMsOrOneIfResultIsZero(maxIdle, maxIdleUnit)) : MapPutCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), ttlMillis);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return (V)this.toObject(MapPutCodec.decodeResponse(response));
    }

    @Override
    public void putTransient(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(timeunit, NULL_TIMEUNIT_IS_NOT_ALLOWED);
        this.putTransientInternal(ttl, timeunit, null, null, key, value);
    }

    @Override
    public void putTransient(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit ttlUnit, long maxIdle, @Nonnull TimeUnit maxIdleUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(ttlUnit, NULL_TTL_UNIT_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(maxIdleUnit, NULL_MAX_IDLE_UNIT_IS_NOT_ALLOWED);
        this.putTransientInternal(ttl, ttlUnit, maxIdle, maxIdleUnit, key, value);
    }

    protected void putTransientInternal(long ttl, TimeUnit timeunit, Long maxIdle, TimeUnit maxIdleUnit, Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        long ttlMillis = TimeUtil.timeInMsOrOneIfResultIsZero(ttl, timeunit);
        ClientMessage request = maxIdle != null ? MapPutTransientWithMaxIdleCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), ttlMillis, TimeUtil.timeInMsOrOneIfResultIsZero(maxIdle, maxIdleUnit)) : MapPutTransientCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), ttlMillis);
        this.invoke(request, keyData);
    }

    @Override
    public V putIfAbsent(@Nonnull K key, @Nonnull V value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        return this.putIfAbsentInternal(-1L, TimeUnit.MILLISECONDS, null, null, key, value);
    }

    @Override
    public V putIfAbsent(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(timeunit, NULL_TIMEUNIT_IS_NOT_ALLOWED);
        return this.putIfAbsentInternal(ttl, timeunit, null, null, key, value);
    }

    @Override
    public V putIfAbsent(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit ttlUnit, long maxIdle, @Nonnull TimeUnit maxIdleUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(ttlUnit, NULL_TTL_UNIT_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(maxIdleUnit, NULL_MAX_IDLE_UNIT_IS_NOT_ALLOWED);
        return this.putIfAbsentInternal(ttl, ttlUnit, maxIdle, maxIdleUnit, key, value);
    }

    protected V putIfAbsentInternal(long ttl, TimeUnit timeunit, Long maxIdle, TimeUnit maxIdleUnit, Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        long ttlMillis = TimeUtil.timeInMsOrOneIfResultIsZero(ttl, timeunit);
        ClientMessage request = maxIdle != null ? MapPutIfAbsentWithMaxIdleCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), ttlMillis, TimeUtil.timeInMsOrOneIfResultIsZero(maxIdle, maxIdleUnit)) : MapPutIfAbsentCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), ttlMillis);
        ClientMessage result = (ClientMessage)this.invoke(request, keyData);
        return (V)this.toObject(MapPutIfAbsentCodec.decodeResponse(result));
    }

    @Override
    public boolean replace(@Nonnull K key, @Nonnull V oldValue, @Nonnull V newValue) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(oldValue, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(newValue, NULL_VALUE_IS_NOT_ALLOWED);
        return this.replaceIfSameInternal(key, oldValue, newValue);
    }

    protected boolean replaceIfSameInternal(Object key, Object oldValue, Object newValue) {
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        ClientMessage request = MapReplaceIfSameCodec.encodeRequest(this.name, keyData, oldValueData, newValueData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return MapReplaceIfSameCodec.decodeResponse(response);
    }

    @Override
    public V replace(@Nonnull K key, @Nonnull V value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        return this.replaceInternal(key, value);
    }

    protected V replaceInternal(Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MapReplaceCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return (V)this.toObject(MapReplaceCodec.decodeResponse(response));
    }

    @Override
    public void set(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit ttlUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(ttlUnit, NULL_TTL_UNIT_IS_NOT_ALLOWED);
        this.setInternal(ttl, ttlUnit, null, null, key, value);
    }

    @Override
    public void set(@Nonnull K key, @Nonnull V value, long ttl, @Nonnull TimeUnit ttlUnit, long maxIdle, @Nonnull TimeUnit maxIdleUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(ttlUnit, NULL_TTL_UNIT_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(maxIdleUnit, NULL_MAX_IDLE_UNIT_IS_NOT_ALLOWED);
        this.setInternal(ttl, ttlUnit, maxIdle, maxIdleUnit, key, value);
    }

    protected void setInternal(long ttl, TimeUnit timeunit, Long maxIdle, TimeUnit maxIdleUnit, Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        long ttlMillis = TimeUtil.timeInMsOrOneIfResultIsZero(ttl, timeunit);
        ClientMessage request = maxIdle != null ? MapSetWithMaxIdleCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), ttlMillis, TimeUtil.timeInMsOrOneIfResultIsZero(maxIdle, maxIdleUnit)) : MapSetCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), ttlMillis);
        this.invoke(request, keyData);
    }

    @Override
    public void lock(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        this.lockInternal(key, TimeUtil.timeInMsOrTimeIfNullUnit(-1L, TimeUnit.MILLISECONDS));
    }

    @Override
    public void lock(@Nonnull K key, long leaseTime, @Nullable TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkPositive("leaseTime", leaseTime);
        this.lockInternal(key, TimeUtil.timeInMsOrTimeIfNullUnit(leaseTime, timeUnit));
    }

    private void lockInternal(@Nonnull K key, long leaseTimeMs) {
        Data keyData = this.toData(key);
        ClientMessage request = MapLockCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId(), leaseTimeMs, this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData, Long.MAX_VALUE);
    }

    private <T> T invoke(ClientMessage clientMessage, Object key, long invocationTimeoutSeconds) {
        int partitionId = this.getContext().getPartitionService().getPartitionId(key);
        try {
            ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), clientMessage, (Object)this.getName(), partitionId);
            clientInvocation.setInvocationTimeoutMillis(invocationTimeoutSeconds);
            ClientInvocationFuture future = clientInvocation.invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public boolean isLocked(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapIsLockedCodec.encodeRequest(this.name, keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return MapIsLockedCodec.decodeResponse(response);
    }

    @Override
    public boolean tryLock(@Nonnull K key) {
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean tryLock(@Nonnull K key, long time, @Nullable TimeUnit timeunit) throws InterruptedException {
        return this.tryLock(key, time, timeunit, -1L, null);
    }

    @Override
    public boolean tryLock(@Nonnull K key, long time, @Nullable TimeUnit timeunit, long leaseTime, @Nullable TimeUnit leaseUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        long leaseTimeMillis = TimeUtil.timeInMsOrTimeIfNullUnit(leaseTime, leaseUnit);
        long timeoutMillis = TimeUtil.timeInMsOrTimeIfNullUnit(time, timeunit);
        ClientMessage request = MapTryLockCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId(), leaseTimeMillis, timeoutMillis, this.lockReferenceIdGenerator.getNextReferenceId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData, Long.MAX_VALUE);
        return MapTryLockCodec.decodeResponse(response);
    }

    @Override
    public void unlock(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapUnlockCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId(), this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    @Override
    public void forceUnlock(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapForceUnlockCodec.encodeRequest(this.name, keyData, this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    @Override
    public UUID addLocalEntryListener(@Nonnull MapListener listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    @Override
    public UUID addLocalEntryListener(@Nonnull MapListener listener, @Nonnull Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    @Override
    public UUID addLocalEntryListener(@Nonnull MapListener listener, @Nonnull Predicate<K, V> predicate, @Nullable K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    @Override
    public String addInterceptor(@Nonnull MapInterceptor interceptor) {
        Preconditions.checkNotNull(interceptor, "Interceptor should not be null!");
        Data data = this.toData(interceptor);
        ClientMessage request = MapAddInterceptorCodec.encodeRequest(this.name, data);
        ClientMessage response = (ClientMessage)this.invoke(request);
        return MapAddInterceptorCodec.decodeResponse(response);
    }

    @Override
    public boolean removeInterceptor(@Nonnull String id) {
        Preconditions.checkNotNull(id, "Interceptor ID should not be null!");
        ClientMessage request = MapRemoveInterceptorCodec.encodeRequest(this.name, id);
        ClientMessage response = (ClientMessage)this.invoke(request);
        return MapRemoveInterceptorCodec.decodeResponse(response);
    }

    @Override
    public UUID addEntryListener(@Nonnull MapListener listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        ListenerAdapter<IMapEvent> listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        return this.addEntryListenerInternal(listenerAdaptor, includeValue);
    }

    private UUID addEntryListenerInternal(ListenerAdapter<IMapEvent> listenerAdaptor, boolean includeValue) {
        int listenerFlags = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdaptor);
        ClientMapEventHandler handler = new ClientMapEventHandler(listenerAdaptor);
        return this.registerListener(this.createMapEntryListenerCodec(includeValue, listenerFlags), handler);
    }

    private ListenerMessageCodec createMapEntryListenerCodec(final boolean includeValue, final int listenerFlags) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddEntryListenerCodec.encodeRequest(ClientMapProxy.this.name, includeValue, listenerFlags, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return MapAddEntryListenerCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest(ClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    @Override
    public boolean removeEntryListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "Listener ID should not be null!");
        return this.deregisterListener(registrationId);
    }

    @Override
    public UUID addPartitionLostListener(@Nonnull MapPartitionLostListener listener) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        ClientMapPartitionLostEventHandler handler = new ClientMapPartitionLostEventHandler(listener);
        return this.registerListener(this.createMapPartitionListenerCodec(), handler);
    }

    private ListenerMessageCodec createMapPartitionListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddPartitionLostListenerCodec.encodeRequest(ClientMapProxy.this.name, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return MapAddPartitionLostListenerCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return MapRemovePartitionLostListenerCodec.encodeRequest(ClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemovePartitionLostListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    @Override
    public boolean removePartitionLostListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "Listener ID should not be null!");
        return this.deregisterListener(registrationId);
    }

    @Override
    public UUID addEntryListener(@Nonnull MapListener listener, @Nonnull K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        ListenerAdapter<IMapEvent> listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        return this.addEntryListenerInternal(listenerAdaptor, key, includeValue);
    }

    private UUID addEntryListenerInternal(ListenerAdapter<IMapEvent> listenerAdaptor, K key, boolean includeValue) {
        int listenerFlags = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdaptor);
        Data keyData = this.toData(key);
        ClientMapToKeyEventHandler handler = new ClientMapToKeyEventHandler(listenerAdaptor);
        return this.registerListener(this.createMapEntryListenerToKeyCodec(includeValue, listenerFlags, keyData), handler);
    }

    private ListenerMessageCodec createMapEntryListenerToKeyCodec(final boolean includeValue, final int listenerFlags, final Data keyData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddEntryListenerToKeyCodec.encodeRequest(ClientMapProxy.this.name, keyData, includeValue, listenerFlags, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return MapAddEntryListenerToKeyCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest(ClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    @Override
    public UUID addEntryListener(@Nonnull MapListener listener, @Nonnull Predicate<K, V> predicate, @Nullable K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        ListenerAdapter<IMapEvent> listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        return key == null ? this.addEntryListenerInternal(listenerAdaptor, predicate, includeValue) : this.addEntryListenerInternal(listenerAdaptor, predicate, key, includeValue);
    }

    private UUID addEntryListenerInternal(@Nonnull ListenerAdapter<IMapEvent> listenerAdaptor, @Nonnull Predicate<K, V> predicate, @Nullable K key, boolean includeValue) {
        int listenerFlags = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdaptor);
        Data keyData = this.toData(key);
        Data predicateData = this.toData(predicate);
        ClientMapToKeyWithPredicateEventHandler handler = new ClientMapToKeyWithPredicateEventHandler(listenerAdaptor);
        ListenerMessageCodec codec = this.createEntryListenerToKeyWithPredicateCodec(includeValue, listenerFlags, keyData, predicateData);
        return this.registerListener(codec, handler);
    }

    private ListenerMessageCodec createEntryListenerToKeyWithPredicateCodec(final boolean includeValue, final int listenerFlags, final Data keyData, final Data predicateData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddEntryListenerToKeyWithPredicateCodec.encodeRequest(ClientMapProxy.this.name, keyData, predicateData, includeValue, listenerFlags, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return MapAddEntryListenerToKeyWithPredicateCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest(ClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    @Override
    public UUID addEntryListener(@Nonnull MapListener listener, @Nonnull Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        ListenerAdapter<IMapEvent> listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        return this.addEntryListenerInternal(listenerAdaptor, predicate, includeValue);
    }

    private UUID addEntryListenerInternal(ListenerAdapter<IMapEvent> listenerAdapter, Predicate<K, V> predicate, boolean includeValue) {
        int listenerFlags = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdapter);
        Data predicateData = this.toData(predicate);
        ClientMapWithPredicateEventHandler handler = new ClientMapWithPredicateEventHandler(listenerAdapter);
        return this.registerListener(this.createEntryListenerWithPredicateCodec(includeValue, listenerFlags, predicateData), handler);
    }

    private ListenerMessageCodec createEntryListenerWithPredicateCodec(final boolean includeValue, final int listenerFlags, final Data predicateData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddEntryListenerWithPredicateCodec.encodeRequest(ClientMapProxy.this.name, predicateData, includeValue, listenerFlags, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return MapAddEntryListenerWithPredicateCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest(ClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    @Override
    public EntryView<K, V> getEntryView(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapGetEntryViewCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapGetEntryViewCodec.ResponseParameters parameters = MapGetEntryViewCodec.decodeResponse(response);
        SimpleEntryView<Data, Data> dataEntryView = parameters.response;
        if (dataEntryView == null) {
            return null;
        }
        return new SimpleEntryView().withKey(this.toObject(dataEntryView.getKey())).withValue(this.toObject(dataEntryView.getValue())).withCost(dataEntryView.getCost()).withCreationTime(dataEntryView.getCreationTime()).withExpirationTime(dataEntryView.getExpirationTime()).withHits(dataEntryView.getHits()).withLastAccessTime(dataEntryView.getLastAccessTime()).withLastStoredTime(dataEntryView.getLastStoredTime()).withLastUpdateTime(dataEntryView.getLastUpdateTime()).withVersion(dataEntryView.getVersion()).withHits(dataEntryView.getHits()).withTtl(dataEntryView.getTtl()).withMaxIdle(parameters.maxIdle);
    }

    @Override
    public boolean evict(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        return this.evictInternal(key);
    }

    protected boolean evictInternal(Object key) {
        Data keyData = this.toData(key);
        ClientMessage request = MapEvictCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return MapEvictCodec.decodeResponse(response);
    }

    @Override
    public void evictAll() {
        ClientMessage request = MapEvictAllCodec.encodeRequest(this.name);
        this.invoke(request);
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        ClientMessage request = MapLoadAllCodec.encodeRequest(this.name, replaceExistingValues);
        this.invoke(request);
    }

    @Override
    public void loadAll(@Nonnull Set<K> keys, boolean replaceExistingValues) {
        Preconditions.checkNotNull(keys, "Parameter keys should not be null.");
        if (keys.isEmpty()) {
            return;
        }
        this.loadAllInternal(replaceExistingValues, keys);
    }

    protected void loadAllInternal(boolean replaceExistingValues, Collection<?> keys) {
        Collection<Data> dataKeys = CollectionUtil.objectToDataCollection(keys, this.getSerializationService());
        ClientMessage request = MapLoadGivenKeysCodec.encodeRequest(this.name, dataKeys, replaceExistingValues);
        this.invoke(request);
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        ClientMessage request = MapKeySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        return new UnmodifiableLazySet(MapKeySetCodec.decodeResponse(response), this.getSerializationService());
    }

    @Override
    public Map<K, V> getAll(@Nullable Set<K> keys) {
        if (CollectionUtil.isEmpty(keys)) {
            return Collections.unmodifiableMap(Collections.emptyMap());
        }
        int keysSize = keys.size();
        HashMap<Integer, List<Data>> partitionToKeyData = new HashMap<Integer, List<Data>>();
        ArrayList<Object> resultingKeyValuePairs = new ArrayList<Object>(keysSize * 2);
        this.getAllInternal(keys, partitionToKeyData, resultingKeyValuePairs);
        Map result = MapUtil.createHashMap(keysSize);
        int i = 0;
        while (i < resultingKeyValuePairs.size()) {
            Object key = this.toObject(resultingKeyValuePairs.get(i++));
            Object value = this.toObject(resultingKeyValuePairs.get(i++));
            result.put(key, value);
        }
        return Collections.unmodifiableMap(result);
    }

    protected void getAllInternal(Set<K> keys, Map<Integer, List<Data>> partitionToKeyData, List<Object> resultingKeyValuePairs) {
        if (partitionToKeyData.isEmpty()) {
            this.fillPartitionToKeyData(keys, partitionToKeyData, null, null);
        }
        ArrayList<ClientInvocationFuture> futures = new ArrayList<ClientInvocationFuture>(partitionToKeyData.size());
        for (Map.Entry<Integer, List<Data>> entry : partitionToKeyData.entrySet()) {
            int partitionId = entry.getKey();
            List<Data> keyList = entry.getValue();
            if (keyList.isEmpty()) continue;
            ClientMessage request = MapGetAllCodec.encodeRequest(this.name, keyList);
            futures.add(new ClientInvocation(this.getClient(), request, (Object)this.getName(), partitionId).invoke());
        }
        for (Future future : futures) {
            try {
                ClientMessage response = (ClientMessage)future.get();
                List<Map.Entry<Data, Data>> entries = MapGetAllCodec.decodeResponse(response);
                for (Map.Entry<Data, Data> entry : entries) {
                    resultingKeyValuePairs.add(entry.getKey());
                    resultingKeyValuePairs.add(entry.getValue());
                }
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    protected void fillPartitionToKeyData(Set<K> keys, Map<Integer, List<Data>> partitionToKeyData, Map<Object, Data> keyMap, Map<Data, Object> reverseKeyMap) {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        for (K key : keys) {
            Data keyData = this.toData(key);
            int partitionId = partitionService.getPartitionId(keyData);
            List<Data> keyList = partitionToKeyData.get(partitionId);
            if (keyList == null) {
                keyList = new ArrayList<Data>();
                partitionToKeyData.put(partitionId, keyList);
            }
            keyList.add(keyData);
            if (keyMap != null) {
                keyMap.put(key, keyData);
            }
            if (reverseKeyMap == null) continue;
            reverseKeyMap.put(keyData, key);
        }
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        ClientMessage request = MapValuesCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        return new UnmodifiableLazyList(MapValuesCodec.decodeResponse(response), this.getSerializationService());
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = MapEntrySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        return this.getEntriesAsImmutableLazySet(MapEntrySetCodec.decodeResponse(response));
    }

    @Override
    public Set<K> keySet(@Nonnull Predicate<K, V> predicate) {
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        if (ClientMapProxy.containsPagingPredicate(predicate)) {
            return this.keySetWithPagingPredicate(predicate);
        }
        ClientMessage request = MapKeySetWithPredicateCodec.encodeRequest(this.name, this.toData(predicate));
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        return new UnmodifiableLazySet(MapKeySetWithPredicateCodec.decodeResponse(response), this.getSerializationService());
    }

    private Set keySetWithPagingPredicate(Predicate predicate) {
        PagingPredicateImpl pagingPredicate = PredicateUtils.unwrapPagingPredicate(predicate);
        pagingPredicate.setIterationType(IterationType.KEY);
        PagingPredicateHolder pagingPredicateHolder = PagingPredicateHolder.of(predicate, this.getSerializationService());
        ClientMessage request = MapKeySetWithPagingPredicateCodec.encodeRequest(this.name, pagingPredicateHolder);
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        MapKeySetWithPagingPredicateCodec.ResponseParameters resultParameters = MapKeySetWithPagingPredicateCodec.decodeResponse(response);
        SerializationService serializationService = this.getSerializationService();
        pagingPredicate.setAnchorList(resultParameters.anchorDataList.asAnchorList(serializationService));
        return new UnmodifiableLazySet(resultParameters.response, serializationService);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(@Nonnull Predicate predicate) {
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        if (ClientMapProxy.containsPagingPredicate(predicate)) {
            return this.entrySetWithPagingPredicate(predicate);
        }
        ClientMessage request = MapEntriesWithPredicateCodec.encodeRequest(this.name, this.toData(predicate));
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        return this.getEntriesAsImmutableLazySet(MapEntriesWithPredicateCodec.decodeResponse(response));
    }

    private Set getEntriesAsImmutableLazySet(List<Map.Entry<Data, Data>> entryDataList) {
        return new UnmodifiableLazySet(entryDataList, this.getSerializationService());
    }

    private Set entrySetWithPagingPredicate(Predicate predicate) {
        PagingPredicateImpl pagingPredicate = PredicateUtils.unwrapPagingPredicate(predicate);
        pagingPredicate.setIterationType(IterationType.ENTRY);
        PagingPredicateHolder pagingPredicateHolder = PagingPredicateHolder.of(predicate, this.getSerializationService());
        ClientMessage request = MapEntriesWithPagingPredicateCodec.encodeRequest(this.name, pagingPredicateHolder);
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        MapEntriesWithPagingPredicateCodec.ResponseParameters resultParameters = MapEntriesWithPagingPredicateCodec.decodeResponse(response);
        pagingPredicate.setAnchorList(resultParameters.anchorDataList.asAnchorList(this.getSerializationService()));
        return this.getEntriesAsImmutableLazySet(resultParameters.response);
    }

    @Override
    public Collection<V> values(@Nonnull Predicate predicate) {
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        if (ClientMapProxy.containsPagingPredicate(predicate)) {
            return this.valuesForPagingPredicate(predicate);
        }
        ClientMessage request = MapValuesWithPredicateCodec.encodeRequest(this.name, this.toData(predicate));
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        List<Data> dataList = MapValuesWithPredicateCodec.decodeResponse(response);
        return new UnmodifiableLazyList(dataList, this.getSerializationService());
    }

    private ClientMessage invokeWithPredicate(ClientMessage request, Predicate predicate) {
        ClientMessage response;
        if (predicate instanceof PartitionPredicate) {
            PartitionPredicate partitionPredicate = (PartitionPredicate)predicate;
            response = (ClientMessage)this.invoke(request, partitionPredicate.getPartitionKey());
        } else {
            response = (ClientMessage)this.invoke(request);
        }
        return response;
    }

    private Collection<V> valuesForPagingPredicate(Predicate predicate) {
        PagingPredicateImpl pagingPredicate = PredicateUtils.unwrapPagingPredicate(predicate);
        pagingPredicate.setIterationType(IterationType.VALUE);
        PagingPredicateHolder pagingPredicateHolder = PagingPredicateHolder.of(predicate, this.getSerializationService());
        ClientMessage request = MapValuesWithPagingPredicateCodec.encodeRequest(this.name, pagingPredicateHolder);
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        MapValuesWithPagingPredicateCodec.ResponseParameters resultParameters = MapValuesWithPagingPredicateCodec.decodeResponse(response);
        SerializationService serializationService = this.getSerializationService();
        pagingPredicate.setAnchorList(resultParameters.anchorDataList.asAnchorList(serializationService));
        return new UnmodifiableLazyList(resultParameters.response, serializationService);
    }

    @Override
    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    @Override
    public Set<K> localKeySet(@Nonnull Predicate predicate) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    @Override
    public void addIndex(IndexConfig indexConfig) {
        Preconditions.checkNotNull(indexConfig, "Index config cannot be null.");
        IndexConfig indexConfig0 = IndexUtils.validateAndNormalize(this.name, indexConfig);
        ClientMessage request = MapAddIndexCodec.encodeRequest(this.name, indexConfig0);
        this.invoke(request);
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        return new LocalMapStatsImpl();
    }

    @Override
    public boolean setTtl(@Nonnull K key, long ttl, @Nonnull TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(timeunit, NULL_TIMEUNIT_IS_NOT_ALLOWED);
        return this.setTtlInternal(key, ttl, timeunit);
    }

    protected boolean setTtlInternal(Object key, long ttl, TimeUnit timeUnit) {
        long ttlMillis = timeUnit.toMillis(ttl);
        Data keyData = this.toData(key);
        ClientMessage request = MapSetTtlCodec.encodeRequest(this.getName(), keyData, ttlMillis);
        ClientMessage result = (ClientMessage)this.invoke(request, keyData);
        return MapSetTtlCodec.decodeResponse(result);
    }

    @Override
    public <R> R executeOnKey(@Nonnull K key, @Nonnull EntryProcessor<K, V, R> entryProcessor) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(entryProcessor, NULL_ENTRY_PROCESSOR_IS_NOT_ALLOWED);
        return this.executeOnKeyInternal(key, entryProcessor);
    }

    public <R> R executeOnKeyInternal(Object key, EntryProcessor<K, V, R> entryProcessor) {
        ClientMapProxy.validateEntryProcessorForSingleKeyProcessing(entryProcessor);
        Data keyData = this.toData(key);
        ClientMessage request = MapExecuteOnKeyCodec.encodeRequest(this.name, this.toData(entryProcessor), keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return (R)this.toObject(MapExecuteOnKeyCodec.decodeResponse(response));
    }

    @Override
    public <R> InternalCompletableFuture<R> submitToKey(@Nonnull K key, @Nonnull EntryProcessor<K, V, R> entryProcessor) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        return this.submitToKeyInternal(key, entryProcessor);
    }

    public <R> InternalCompletableFuture<R> submitToKeyInternal(Object key, EntryProcessor<K, V, R> entryProcessor) {
        try {
            Data keyData = this.toData(key);
            ClientMessage request = MapSubmitToKeyCodec.encodeRequest(this.name, this.toData(entryProcessor), keyData, ThreadUtil.getThreadId());
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            SerializationService ss = this.getSerializationService();
            return new ClientDelegatingFuture(future, ss, MapSubmitToKeyCodec::decodeResponse);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public <R> Map<K, R> executeOnEntries(@Nonnull EntryProcessor<K, V, R> entryProcessor) {
        ClientMessage request = MapExecuteOnAllKeysCodec.encodeRequest(this.name, this.toData(entryProcessor));
        ClientMessage response = (ClientMessage)this.invoke(request);
        return this.prepareResult(MapExecuteOnAllKeysCodec.decodeResponse(response));
    }

    protected <R> Map<K, R> prepareResult(Collection<Map.Entry<Data, Data>> entries) {
        if (CollectionUtil.isEmpty(entries)) {
            return Collections.emptyMap();
        }
        Map result = MapUtil.createHashMap(entries.size());
        for (Map.Entry<Data, Data> entry : entries) {
            Object key = this.toObject(entry.getKey());
            result.put(key, this.toObject(entry.getValue()));
        }
        return result;
    }

    @Override
    public <R> Map<K, R> executeOnEntries(@Nonnull EntryProcessor<K, V, R> entryProcessor, @Nonnull Predicate<K, V> predicate) {
        ClientMessage request = MapExecuteWithPredicateCodec.encodeRequest(this.name, this.toData(entryProcessor), this.toData(predicate));
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        return this.prepareResult(MapExecuteWithPredicateCodec.decodeResponse(response));
    }

    @Override
    public <R> R aggregate(@Nonnull Aggregator<? super Map.Entry<K, V>, R> aggregator) {
        Preconditions.checkNotNull(aggregator, NULL_AGGREGATOR_IS_NOT_ALLOWED);
        ClientMessage request = MapAggregateCodec.encodeRequest(this.name, this.toData(aggregator));
        ClientMessage response = (ClientMessage)this.invoke(request);
        return (R)this.toObject(MapAggregateCodec.decodeResponse(response));
    }

    @Override
    public <R> R aggregate(@Nonnull Aggregator<? super Map.Entry<K, V>, R> aggregator, @Nonnull Predicate<K, V> predicate) {
        Preconditions.checkNotNull(aggregator, NULL_AGGREGATOR_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        ClientMapProxy.checkNotPagingPredicate(predicate, "aggregate");
        ClientMessage request = MapAggregateWithPredicateCodec.encodeRequest(this.name, this.toData(aggregator), this.toData(predicate));
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        return (R)this.toObject(MapAggregateWithPredicateCodec.decodeResponse(response));
    }

    @Override
    public <R> Collection<R> project(@Nonnull Projection<? super Map.Entry<K, V>, R> projection) {
        Preconditions.checkNotNull(projection, NULL_PROJECTION_IS_NOT_ALLOWED);
        ClientMessage request = MapProjectCodec.encodeRequest(this.name, this.toData(projection));
        ClientMessage response = (ClientMessage)this.invoke(request);
        return new UnmodifiableLazyList(MapProjectCodec.decodeResponse(response), this.getSerializationService());
    }

    @Override
    public <R> Collection<R> project(@Nonnull Projection<? super Map.Entry<K, V>, R> projection, @Nonnull Predicate<K, V> predicate) {
        Preconditions.checkNotNull(projection, NULL_PROJECTION_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        ClientMapProxy.checkNotPagingPredicate(predicate, "project");
        ClientMessage request = MapProjectWithPredicateCodec.encodeRequest(this.name, this.toData(projection), this.toData(predicate));
        ClientMessage response = this.invokeWithPredicate(request, predicate);
        return new UnmodifiableLazyList(MapProjectWithPredicateCodec.decodeResponse(response), this.getSerializationService());
    }

    @Override
    public QueryCache<K, V> getQueryCache(@Nonnull String name) {
        Preconditions.checkNotNull(name, "name cannot be null");
        return this.getQueryCacheInternal(name, null, null, null, this);
    }

    @Override
    public QueryCache<K, V> getQueryCache(@Nonnull String name, @Nonnull Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(name, "name cannot be null");
        Preconditions.checkNotNull(predicate, "predicate cannot be null");
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, "predicate");
        return this.getQueryCacheInternal(name, null, predicate, includeValue, this);
    }

    @Override
    public QueryCache<K, V> getQueryCache(@Nonnull String name, @Nonnull MapListener listener, @Nonnull Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(name, "name cannot be null");
        Preconditions.checkNotNull(listener, "listener cannot be null");
        Preconditions.checkNotNull(predicate, "predicate cannot be null");
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, "predicate");
        return this.getQueryCacheInternal(name, listener, predicate, includeValue, this);
    }

    private QueryCache<K, V> getQueryCacheInternal(String name, MapListener listener, Predicate predicate, Boolean includeValue, IMap map) {
        QueryCacheRequest request = QueryCacheRequest.newQueryCacheRequest().withCacheName(name).withListener(listener).withPredicate(predicate).withIncludeValue(includeValue).forMap(map).withContext(this.queryCacheContext);
        return this.createQueryCache(request);
    }

    private QueryCache<K, V> createQueryCache(QueryCacheRequest request) {
        SubscriberContext subscriberContext = this.queryCacheContext.getSubscriberContext();
        QueryCacheEndToEndProvider queryCacheEndToEndProvider = subscriberContext.getEndToEndQueryCacheProvider();
        return queryCacheEndToEndProvider.getOrCreateQueryCache(request.getMapName(), request.getCacheName(), subscriberContext.newEndToEndConstructor(request));
    }

    @Override
    public <R> Map<K, R> executeOnKeys(@Nonnull Set<K> keys, @Nonnull EntryProcessor<K, V, R> entryProcessor) {
        try {
            return (Map)((CompletableFuture)this.submitToKeys((Set)keys, (EntryProcessor)entryProcessor)).get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public <R> InternalCompletableFuture<Map<K, R>> submitToKeys(@Nonnull Set<K> keys, @Nonnull EntryProcessor<K, V, R> entryProcessor) {
        Preconditions.checkNotNull(keys, NULL_KEY_IS_NOT_ALLOWED);
        if (keys.isEmpty()) {
            return InternalCompletableFuture.newCompletedFuture(Collections.emptyMap());
        }
        Collection<Data> dataKeys = CollectionUtil.objectToDataCollection(keys, this.getSerializationService());
        return this.submitToKeysInternal(keys, dataKeys, entryProcessor);
    }

    @Nonnull
    protected <R> InternalCompletableFuture<Map<K, R>> submitToKeysInternal(@Nonnull Set<K> objectKeys, @Nonnull Collection<Data> dataKeys, @Nonnull EntryProcessor<K, V, R> entryProcessor) {
        ClientMessage request = MapExecuteOnKeysCodec.encodeRequest(this.name, this.toData(entryProcessor), dataKeys);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.getName()).invoke();
        return new ClientDelegatingFuture<Map<K, R>>(future, this.getSerializationService(), message -> this.prepareResult(MapExecuteOnKeysCodec.decodeResponse(message)));
    }

    @Override
    public void set(@Nonnull K key, @Nonnull V value) {
        this.set(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public int size() {
        ClientMessage request = MapSizeCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        return MapSizeCodec.decodeResponse(response);
    }

    @Override
    public boolean isEmpty() {
        ClientMessage request = MapIsEmptyCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        return MapIsEmptyCodec.decodeResponse(response);
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        this.putAllInternal(m, null, true);
    }

    public InternalCompletableFuture<Void> putAllAsync(@Nonnull Map<? extends K, ? extends V> m) {
        InternalCompletableFuture<Void> future = new InternalCompletableFuture<Void>();
        this.putAllInternal(m, future, true);
        return future;
    }

    @Override
    public void setAll(@Nonnull Map<? extends K, ? extends V> m) {
        this.putAllInternal(m, null, false);
    }

    public InternalCompletableFuture<Void> setAllAsync(@Nonnull Map<? extends K, ? extends V> m) {
        InternalCompletableFuture<Void> future = new InternalCompletableFuture<Void>();
        this.putAllInternal(m, future, false);
        return future;
    }

    private void putAllInternal(@Nonnull Map<? extends K, ? extends V> map, @Nullable InternalCompletableFuture<Void> future, boolean triggerMapLoader) {
        if (map.isEmpty()) {
            if (future != null) {
                future.complete(null);
            }
            return;
        }
        Preconditions.checkNotNull(map, "Null argument map is not allowed");
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        HashMap<Integer, ArrayList<AbstractMap.SimpleEntry<Data, Data>>> entryMap = new HashMap<Integer, ArrayList<AbstractMap.SimpleEntry<Data, Data>>>(partitionCount);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Preconditions.checkNotNull(entry.getKey(), NULL_KEY_IS_NOT_ALLOWED);
            Preconditions.checkNotNull(entry.getValue(), NULL_VALUE_IS_NOT_ALLOWED);
            Data keyData = this.toData(entry.getKey());
            int partitionId = partitionService.getPartitionId(keyData);
            ArrayList<AbstractMap.SimpleEntry<Data, Data>> partition = (ArrayList<AbstractMap.SimpleEntry<Data, Data>>)entryMap.get(partitionId);
            if (partition == null) {
                partition = new ArrayList<AbstractMap.SimpleEntry<Data, Data>>();
                entryMap.put(partitionId, partition);
            }
            partition.add(new AbstractMap.SimpleEntry<Data, Data>(keyData, this.toData(entry.getValue())));
        }
        assert (entryMap.size() > 0);
        AtomicInteger counter = new AtomicInteger(entryMap.size());
        InternalCompletableFuture resultFuture = future != null ? future : new InternalCompletableFuture();
        BiConsumer<ClientMessage, Throwable> callback = (response, t) -> {
            if (t != null) {
                resultFuture.completeExceptionally((Throwable)t);
            }
            if (counter.decrementAndGet() == 0) {
                this.finalizePutAll(map, entryMap);
                if (!resultFuture.isDone()) {
                    resultFuture.complete(null);
                }
            }
        };
        for (Map.Entry entry : entryMap.entrySet()) {
            Integer partitionId = (Integer)entry.getKey();
            ClientMessage request = MapPutAllCodec.encodeRequest(this.name, (Collection)entry.getValue(), triggerMapLoader);
            new ClientInvocation(this.getClient(), request, (Object)this.getName(), partitionId).invoke().whenCompleteAsync(callback);
        }
        if (future == null) {
            try {
                resultFuture.get();
            }
            catch (Throwable e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    protected void finalizePutAll(Map<? extends K, ? extends V> map, Map<Integer, List<Map.Entry<Data, Data>>> entryMap) {
    }

    @Override
    public void clear() {
        ClientMessage request = MapClearCodec.encodeRequest(this.name);
        this.invoke(request);
    }

    public String toString() {
        return "IMap{name='" + this.name + '\'' + '}';
    }

    public Iterator<Map.Entry<K, V>> iterator(int fetchSize, int partitionId, boolean prefetchValues) {
        return new ClientMapPartitionIterator(this, this.getContext(), fetchSize, partitionId, prefetchValues);
    }

    public <R> Iterator<R> iterator(int fetchSize, int partitionId, Projection<? super Map.Entry<K, V>, R> projection, Predicate<K, V> predicate) {
        Preconditions.checkNotNull(projection, NULL_PROJECTION_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        ClientMapProxy.checkNotPagingPredicate(predicate, "iterator");
        return new ClientMapQueryPartitionIterator<K, V, R>(this, this.getContext(), fetchSize, partitionId, predicate, projection);
    }

    public InternalCompletableFuture<EventJournalInitialSubscriberState> subscribeToEventJournal(int partitionId) {
        ClientMessage request = MapEventJournalSubscribeCodec.encodeRequest(this.name);
        ClientInvocationFuture fut = new ClientInvocation(this.getClient(), request, (Object)this.getName(), partitionId).invoke();
        return new ClientDelegatingFuture<EventJournalInitialSubscriberState>(fut, this.getSerializationService(), message -> {
            MapEventJournalSubscribeCodec.ResponseParameters resp = MapEventJournalSubscribeCodec.decodeResponse(message);
            return new EventJournalInitialSubscriberState(resp.oldestSequence, resp.newestSequence);
        });
    }

    @Override
    public <T> InternalCompletableFuture<ReadResultSet<T>> readFromEventJournal(long startSequence, int minSize, int maxSize, int partitionId, java.util.function.Predicate<? super EventJournalMapEvent<K, V>> predicate, Function<? super EventJournalMapEvent<K, V>, ? extends T> projection) {
        if (maxSize < minSize) {
            throw new IllegalArgumentException("maxSize " + maxSize + " must be greater or equal to minSize " + minSize);
        }
        SerializationService ss = this.getSerializationService();
        ClientMessage request = MapEventJournalReadCodec.encodeRequest(this.name, startSequence, minSize, maxSize, ss.toData(predicate), ss.toData(projection));
        ClientInvocationFuture fut = new ClientInvocation(this.getClient(), request, (Object)this.getName(), partitionId).invoke();
        return new ClientDelegatingFuture<ReadResultSet<T>>(fut, ss, message -> {
            MapEventJournalReadCodec.ResponseParameters params = MapEventJournalReadCodec.decodeResponse(message);
            ReadResultSetImpl resultSet = new ReadResultSetImpl(params.readCount, params.items, params.itemSeqs, params.nextSeq);
            resultSet.setSerializationService(this.getSerializationService());
            return resultSet;
        });
    }

    public ClientQueryCacheContext getQueryCacheContext() {
        return this.queryCacheContext;
    }

    private static void validateEntryProcessorForSingleKeyProcessing(EntryProcessor entryProcessor) {
        EntryProcessor backupProcessor;
        if (entryProcessor instanceof ReadOnly && (backupProcessor = entryProcessor.getBackupProcessor()) != null) {
            throw new IllegalArgumentException("EntryProcessor.getBackupProcessor() should be null for a read-only EntryProcessor");
        }
    }

    private static void checkNotPagingPredicate(Predicate predicate, String method) {
        if (predicate instanceof PagingPredicate) {
            throw new IllegalArgumentException("PagingPredicate not supported in " + method + " method");
        }
    }

    private static boolean containsPagingPredicate(Predicate predicate) {
        if (predicate instanceof PagingPredicateImpl) {
            return true;
        }
        if (!(predicate instanceof PartitionPredicate)) {
            return false;
        }
        PartitionPredicate partitionPredicate = (PartitionPredicate)predicate;
        return partitionPredicate.getTarget() instanceof PagingPredicateImpl;
    }

    @Override
    protected void onDestroy() {
        try {
            SubscriberContext subscriberContext = this.queryCacheContext.getSubscriberContext();
            QueryCacheEndToEndProvider provider = subscriberContext.getEndToEndQueryCacheProvider();
            provider.destroyAllQueryCaches(this.name);
        }
        finally {
            super.onDestroy();
        }
    }

    @Override
    public V computeIfPresent(@Nonnull K key, @Nonnull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, NULL_BIFUNCTION_IS_NOT_ALLOWED);
        return this.computeIfPresentLocally(key, remappingFunction);
    }

    private V computeIfPresentLocally(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        while (true) {
            Data oldValueAsData;
            if ((oldValueAsData = this.toData(this.getInternal(key))) == null) {
                return null;
            }
            Object oldValueClone = this.toObject(oldValueAsData);
            V newValue = remappingFunction.apply(key, oldValueClone);
            if (newValue != null) {
                if (!this.replaceIfSameInternal(key, oldValueAsData, this.toData(newValue))) continue;
                return newValue;
            }
            if (this.removeInternal(key, oldValueAsData)) break;
        }
        return null;
    }

    @Override
    public V computeIfAbsent(@Nonnull K key, @Nonnull Function<? super K, ? extends V> mappingFunction) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(mappingFunction, NULL_FUNCTION_IS_NOT_ALLOWED);
        return this.computeIfAbsentLocally(key, mappingFunction);
    }

    private V computeIfAbsentLocally(K key, Function<? super K, ? extends V> mappingFunction) {
        Object oldValue = this.toObject(this.getInternal(key));
        if (oldValue != null) {
            return (V)oldValue;
        }
        V newValue = mappingFunction.apply(key);
        if (newValue == null) {
            return null;
        }
        V result = this.putIfAbsentInternal(-1L, TimeUnit.MILLISECONDS, null, null, key, this.toData(newValue));
        if (result == null) {
            return newValue;
        }
        return result;
    }

    @Override
    public V compute(@Nonnull K key, @Nonnull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, NULL_BIFUNCTION_IS_NOT_ALLOWED);
        return this.computeLocally(key, remappingFunction);
    }

    private V computeLocally(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        block3: {
            V newValue;
            while (true) {
                Data oldValueAsData = this.toData(this.getInternal(key));
                Object oldValueClone = this.toObject(oldValueAsData);
                newValue = remappingFunction.apply(key, oldValueClone);
                if (oldValueAsData != null) {
                    if (newValue != null) {
                        if (!this.replaceIfSameInternal(key, oldValueAsData, this.toData(newValue))) continue;
                        return newValue;
                    }
                    if (!this.removeInternal(key, oldValueAsData)) continue;
                    return null;
                }
                if (newValue == null) break block3;
                V result = this.putIfAbsentInternal(-1L, TimeUnit.MILLISECONDS, null, null, key, this.toData(newValue));
                if (result == null) break;
            }
            return newValue;
        }
        return null;
    }

    @Override
    public V merge(@Nonnull K key, @Nonnull V value, @Nonnull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(remappingFunction, NULL_BIFUNCTION_IS_NOT_ALLOWED);
        return this.mergeLocally(key, value, remappingFunction);
    }

    private V mergeLocally(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Data keyAsData = this.toData(key);
        while (true) {
            Data oldValueAsData;
            if ((oldValueAsData = this.toData(this.getInternal(keyAsData))) != null) {
                Object oldValueClone = this.toObject(oldValueAsData);
                V newValue = remappingFunction.apply(oldValueClone, value);
                if (newValue != null) {
                    if (!this.replaceIfSameInternal(keyAsData, oldValueAsData, this.toData(newValue))) continue;
                    return newValue;
                }
                if (!this.removeInternal(keyAsData, oldValueAsData)) continue;
                return null;
            }
            V result = this.putIfAbsentInternal(-1L, TimeUnit.MILLISECONDS, null, null, keyAsData, this.toData(value));
            if (result == null) break;
        }
        return value;
    }

    private class ClientMapPartitionLostEventHandler
    extends MapAddPartitionLostListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private MapPartitionLostListener listener;

        ClientMapPartitionLostEventHandler(MapPartitionLostListener listener) {
            this.listener = listener;
        }

        @Override
        public void handleMapPartitionLostEvent(int partitionId, UUID uuid) {
            Member member = ClientMapProxy.this.getContext().getClusterService().getMember(uuid);
            this.listener.partitionLost(new MapPartitionLostEvent(ClientMapProxy.this.name, member, -1, partitionId));
        }
    }

    private abstract class AbstractClientMapEventHandler
    implements EventHandler<ClientMessage> {
        private ListenerAdapter<IMapEvent> listenerAdapter;

        AbstractClientMapEventHandler(ListenerAdapter<IMapEvent> listenerAdapter) {
            this.listenerAdapter = listenerAdapter;
        }

        public void handleEntryEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
            Member member = ClientMapProxy.this.getContext().getClusterService().getMember(uuid);
            this.listenerAdapter.onEvent(this.createIMapEvent(key, value, oldValue, mergingValue, eventType, numberOfAffectedEntries, member));
        }

        private IMapEvent createIMapEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, int numberOfAffectedEntries, Member member) {
            EntryEventType entryEventType = EntryEventType.getByType(eventType);
            Preconditions.checkNotNull(entryEventType, "Unknown eventType: " + eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: 
                case EXPIRED: 
                case MERGED: 
                case LOADED: {
                    return this.createEntryEvent(key, value, oldValue, mergingValue, eventType, member);
                }
                case EVICT_ALL: 
                case CLEAR_ALL: {
                    return this.createMapEvent(eventType, numberOfAffectedEntries, member);
                }
            }
            throw new IllegalArgumentException("Not a known event type: " + (Object)((Object)entryEventType));
        }

        private MapEvent createMapEvent(int eventType, int numberOfAffectedEntries, Member member) {
            return new MapEvent(ClientMapProxy.this.name, member, eventType, numberOfAffectedEntries);
        }

        private EntryEvent<K, V> createEntryEvent(Data keyData, Data valueData, Data oldValueData, Data mergingValueData, int eventType, Member member) {
            return new DataAwareEntryEvent(member, eventType, ClientMapProxy.this.name, keyData, valueData, oldValueData, mergingValueData, ClientMapProxy.this.getSerializationService());
        }
    }

    private class ClientMapEventHandler
    extends AbstractClientMapEventHandler {
        private MapAddEntryListenerCodec.AbstractEventHandler handler;

        ClientMapEventHandler(ListenerAdapter<IMapEvent> listenerAdapter) {
            super(listenerAdapter);
            this.handler = new MapAddEntryListenerCodec.AbstractEventHandler(){

                @Override
                public void handleEntryEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
                    ClientMapEventHandler.this.handleEntryEvent(key, value, oldValue, mergingValue, eventType, uuid, numberOfAffectedEntries);
                }
            };
        }

        @Override
        public void handle(ClientMessage event) {
            this.handler.handle(event);
        }
    }

    private class ClientMapToKeyEventHandler
    extends AbstractClientMapEventHandler {
        private MapAddEntryListenerToKeyCodec.AbstractEventHandler handler;

        ClientMapToKeyEventHandler(ListenerAdapter<IMapEvent> listenerAdapter) {
            super(listenerAdapter);
            this.handler = new MapAddEntryListenerToKeyCodec.AbstractEventHandler(){

                @Override
                public void handleEntryEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
                    ClientMapToKeyEventHandler.this.handleEntryEvent(key, value, oldValue, mergingValue, eventType, uuid, numberOfAffectedEntries);
                }
            };
        }

        @Override
        public void handle(ClientMessage event) {
            this.handler.handle(event);
        }
    }

    private class ClientMapWithPredicateEventHandler
    extends AbstractClientMapEventHandler {
        private MapAddEntryListenerWithPredicateCodec.AbstractEventHandler handler;

        ClientMapWithPredicateEventHandler(ListenerAdapter<IMapEvent> listenerAdapter) {
            super(listenerAdapter);
            this.handler = new MapAddEntryListenerWithPredicateCodec.AbstractEventHandler(){

                @Override
                public void handleEntryEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
                    ClientMapWithPredicateEventHandler.this.handleEntryEvent(key, value, oldValue, mergingValue, eventType, uuid, numberOfAffectedEntries);
                }
            };
        }

        @Override
        public void handle(ClientMessage event) {
            this.handler.handle(event);
        }
    }

    private class ClientMapToKeyWithPredicateEventHandler
    extends AbstractClientMapEventHandler {
        private MapAddEntryListenerToKeyWithPredicateCodec.AbstractEventHandler handler;

        ClientMapToKeyWithPredicateEventHandler(ListenerAdapter<IMapEvent> listenerAdapter) {
            super(listenerAdapter);
            this.handler = new MapAddEntryListenerToKeyWithPredicateCodec.AbstractEventHandler(){

                @Override
                public void handleEntryEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
                    ClientMapToKeyWithPredicateEventHandler.this.handleEntryEvent(key, value, oldValue, mergingValue, eventType, uuid, numberOfAffectedEntries);
                }
            };
        }

        @Override
        public void handle(ClientMessage event) {
            this.handler.handle(event);
        }
    }
}

