/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql;

import com.hazelcast.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class SqlStatement {
    public static final long TIMEOUT_NOT_SET = -1L;
    public static final long TIMEOUT_DISABLED = 0L;
    public static final long DEFAULT_TIMEOUT = -1L;
    public static final int DEFAULT_CURSOR_BUFFER_SIZE = 4096;
    private String sql;
    private List<Object> parameters = new ArrayList<Object>();
    private long timeout = -1L;
    private int cursorBufferSize = 4096;

    public SqlStatement(@Nonnull String sql) {
        this.setSql(sql);
    }

    private SqlStatement(String sql, List<Object> parameters, long timeout, int cursorBufferSize) {
        this.sql = sql;
        this.parameters = parameters;
        this.timeout = timeout;
        this.cursorBufferSize = cursorBufferSize;
    }

    @Nonnull
    public String getSql() {
        return this.sql;
    }

    @Nonnull
    public SqlStatement setSql(@Nonnull String sql) {
        Preconditions.checkNotNull(sql, "SQL cannot be null");
        if (sql.length() == 0) {
            throw new IllegalArgumentException("SQL cannot be empty");
        }
        this.sql = sql;
        return this;
    }

    @Nonnull
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Nonnull
    public SqlStatement setParameters(List<Object> parameters) {
        this.parameters = parameters == null || parameters.isEmpty() ? new ArrayList<Object>() : new ArrayList<Object>(parameters);
        return this;
    }

    @Nonnull
    public SqlStatement addParameter(Object parameter) {
        this.parameters.add(parameter);
        return this;
    }

    @Nonnull
    public SqlStatement clearParameters() {
        this.parameters = new ArrayList<Object>();
        return this;
    }

    public long getTimeoutMillis() {
        return this.timeout;
    }

    @Nonnull
    public SqlStatement setTimeoutMillis(long timeout) {
        if (timeout < 0L && timeout != -1L) {
            throw new IllegalArgumentException("Timeout must be non-negative or -1: " + timeout);
        }
        this.timeout = timeout;
        return this;
    }

    public int getCursorBufferSize() {
        return this.cursorBufferSize;
    }

    @Nonnull
    public SqlStatement setCursorBufferSize(int cursorBufferSize) {
        if (cursorBufferSize <= 0) {
            throw new IllegalArgumentException("Cursor buffer size must be positive: " + cursorBufferSize);
        }
        this.cursorBufferSize = cursorBufferSize;
        return this;
    }

    @Nonnull
    public SqlStatement copy() {
        return new SqlStatement(this.sql, new ArrayList<Object>(this.parameters), this.timeout, this.cursorBufferSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlStatement sqlStatement = (SqlStatement)o;
        return Objects.equals(this.sql, sqlStatement.sql) && Objects.equals(this.parameters, sqlStatement.parameters) && this.timeout == sqlStatement.timeout && this.cursorBufferSize == sqlStatement.cursorBufferSize;
    }

    public int hashCode() {
        int result = this.sql != null ? this.sql.hashCode() : 0;
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + this.cursorBufferSize;
        return result;
    }

    public String toString() {
        return "SqlStatement{sql=" + this.sql + ", parameters=" + this.parameters + ", timeout=" + this.timeout + ", cursorBufferSize=" + this.cursorBufferSize + '}';
    }
}

