/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache;

import com.hazelcast.internal.eviction.Evictable;
import com.hazelcast.internal.eviction.Expirable;
import com.hazelcast.internal.util.TimeUtil;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public interface NearCacheRecord<V>
extends Expirable,
Evictable<V> {
    public static final long EPOCH_TIME = TimeUtil.zeroOutMs(1514764800000L);
    public static final int TIME_NOT_SET = -1;
    public static final long NOT_RESERVED = -1L;
    public static final long READ_PERMITTED = -2L;

    public void setValue(V var1);

    public void setCreationTime(long var1);

    public void setLastAccessTime(long var1);

    public void setHits(int var1);

    public void incrementHits();

    public long getReservationId();

    public void setReservationId(long var1);

    public int getPartitionId();

    public void setPartitionId(int var1);

    public long getInvalidationSequence();

    public void setInvalidationSequence(long var1);

    public void setUuid(UUID var1);

    public boolean hasSameUuid(UUID var1);

    public boolean isCachedAsNull();

    public void setCachedAsNull(boolean var1);

    default public int stripBaseTime(long timeInMillis) {
        if (timeInMillis > 0L) {
            return (int)TimeUnit.MILLISECONDS.toSeconds(timeInMillis - EPOCH_TIME);
        }
        return -1;
    }

    default public long recomputeWithBaseTime(int trimmedTime) {
        if (trimmedTime == -1) {
            return -1L;
        }
        long exploded = TimeUnit.SECONDS.toMillis(trimmedTime);
        return exploded + EPOCH_TIME;
    }

    @Override
    default public boolean isExpiredAt(long now) {
        long expirationTime = this.getExpirationTime();
        return expirationTime > -1L && expirationTime <= now;
    }

    default public boolean isIdleAt(long maxIdleMilliSeconds, long now) {
        if (maxIdleMilliSeconds <= 0L) {
            return false;
        }
        long lastAccessTime = this.getLastAccessTime();
        return lastAccessTime > -1L ? lastAccessTime + maxIdleMilliSeconds < now : this.getCreationTime() + maxIdleMilliSeconds < now;
    }
}

