/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.plan;

import com.hazelcast.org.apache.calcite.config.CalciteConnectionConfig;
import com.hazelcast.org.apache.calcite.jdbc.CalciteSchema;
import com.hazelcast.org.apache.calcite.materialize.Lattice;
import com.hazelcast.org.apache.calcite.materialize.MaterializationService;
import com.hazelcast.org.apache.calcite.materialize.TileKey;
import com.hazelcast.org.apache.calcite.plan.RelOptMaterialization;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.apache.calcite.util.Pair;
import java.util.List;

public class RelOptLattice {
    public final Lattice lattice;
    public final RelOptTable starRelOptTable;

    public RelOptLattice(Lattice lattice, RelOptTable starRelOptTable) {
        this.lattice = lattice;
        this.starRelOptTable = starRelOptTable;
    }

    public RelOptTable rootTable() {
        return this.lattice.rootNode.relOptTable();
    }

    public RelNode rewrite(RelNode node) {
        return RelOptMaterialization.tryUseStar(node, this.starRelOptTable);
    }

    public Pair<CalciteSchema.TableEntry, TileKey> getAggregate(RelOptPlanner planner, ImmutableBitSet groupSet, List<Lattice.Measure> measureList) {
        CalciteConnectionConfig config = planner.getContext().unwrap(CalciteConnectionConfig.class);
        if (config == null) {
            return null;
        }
        MaterializationService service = MaterializationService.instance();
        boolean create = this.lattice.auto && config.createMaterializations();
        CalciteSchema schema = this.starRelOptTable.unwrap(CalciteSchema.class);
        return service.defineTile(this.lattice, groupSet, measureList, schema, create, false);
    }
}

