/*
 * Copyright (c) 2008-2020, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.sql.impl.exec.io;

/**
 * The interface that defines whether the row at the given index qualifies to be sent through this outbox.
 */
public interface OutboxSendQualifier {
    /**
     * @param rowIndex Index of the row in the batch.
     * @return {@code true} if the row should be sent by this outbox, {@code false} if the row should be skipped.
     */
    boolean shouldSend(int rowIndex);
}
