/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.validate;

import com.hazelcast.com.google.common.collect.ImmutableMap;
import com.hazelcast.com.google.common.collect.Lists;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumUtils;
import com.hazelcast.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.linq4j.tree.FunctionExpression;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import com.hazelcast.org.apache.calcite.schema.Function;
import com.hazelcast.org.apache.calcite.schema.FunctionParameter;
import com.hazelcast.org.apache.calcite.schema.TableMacro;
import com.hazelcast.org.apache.calcite.schema.TranslatableTable;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.org.apache.calcite.util.ImmutableNullableList;
import com.hazelcast.org.apache.calcite.util.NlsString;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SqlUserDefinedTableMacro
extends SqlFunction {
    private final TableMacro tableMacro;

    public SqlUserDefinedTableMacro(SqlIdentifier opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> paramTypes, TableMacro tableMacro) {
        super(Util.last(opName.names), opName, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, Objects.requireNonNull(paramTypes), SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        this.tableMacro = tableMacro;
    }

    @Override
    public List<String> getParamNames() {
        return Lists.transform(this.tableMacro.getParameters(), FunctionParameter::getName);
    }

    public TranslatableTable getTable(RelDataTypeFactory typeFactory, List<SqlNode> operandList) {
        List<Object> arguments = SqlUserDefinedTableMacro.convertArguments(typeFactory, operandList, this.tableMacro, this.getNameAsId(), true);
        return this.tableMacro.apply(arguments);
    }

    public static List<Object> convertArguments(RelDataTypeFactory typeFactory, List<SqlNode> operandList, Function function, SqlIdentifier opName, boolean failOnNonLiteral) {
        ArrayList<Object> arguments = new ArrayList<Object>(operandList.size());
        for (Pair<FunctionParameter, SqlNode> pair : Pair.zip(function.getParameters(), operandList)) {
            try {
                Object o = SqlUserDefinedTableMacro.getValue((SqlNode)pair.right);
                Object o2 = SqlUserDefinedTableMacro.coerce(o, ((FunctionParameter)pair.left).getType(typeFactory));
                arguments.add(o2);
            }
            catch (NonLiteralException e) {
                if (failOnNonLiteral) {
                    throw new IllegalArgumentException("All arguments of call to macro " + opName + " should be literal. Actual argument #" + ((FunctionParameter)pair.left).getOrdinal() + " (" + ((FunctionParameter)pair.left).getName() + ") is not literal: " + pair.right);
                }
                RelDataType type = ((FunctionParameter)pair.left).getType(typeFactory);
                Long value = type.isNullable() ? null : Long.valueOf(0L);
                arguments.add(value);
            }
        }
        return arguments;
    }

    private static Object getValue(SqlNode right) throws NonLiteralException {
        switch (right.getKind()) {
            case ARRAY_VALUE_CONSTRUCTOR: {
                ArrayList<Object> list = new ArrayList<Object>();
                for (SqlNode o : ((SqlCall)right).getOperandList()) {
                    list.add(SqlUserDefinedTableMacro.getValue(o));
                }
                return ImmutableNullableList.copyOf(list);
            }
            case MAP_VALUE_CONSTRUCTOR: {
                ImmutableMap.Builder<Object, Object> builder2 = ImmutableMap.builder();
                List<SqlNode> operands = ((SqlCall)right).getOperandList();
                for (int i = 0; i < operands.size(); i += 2) {
                    SqlNode key = operands.get(i);
                    SqlNode value = operands.get(i + 1);
                    builder2.put(SqlUserDefinedTableMacro.getValue(key), SqlUserDefinedTableMacro.getValue(value));
                }
                return builder2.build();
            }
            case CAST: {
                return SqlUserDefinedTableMacro.getValue(((SqlCall)right).operand(0));
            }
        }
        if (SqlUtil.isNullLiteral(right, true)) {
            return null;
        }
        if (SqlUtil.isLiteral(right)) {
            return ((SqlLiteral)right).getValue();
        }
        if (right.getKind() == SqlKind.DEFAULT) {
            return null;
        }
        throw new NonLiteralException();
    }

    private static Object coerce(Object o, RelDataType type) {
        if (o == null) {
            return null;
        }
        if (!(type instanceof RelDataTypeFactoryImpl.JavaType)) {
            return null;
        }
        RelDataTypeFactoryImpl.JavaType javaType = (RelDataTypeFactoryImpl.JavaType)type;
        Class clazz = javaType.getJavaClass();
        if (clazz.isAssignableFrom(o.getClass())) {
            return o;
        }
        if (o instanceof NlsString) {
            return SqlUserDefinedTableMacro.coerce(((NlsString)o).getValue(), type);
        }
        BlockBuilder bb = new BlockBuilder();
        Expression expr = EnumUtils.convert(Expressions.constant(o), clazz);
        bb.add(Expressions.return_(null, expr));
        FunctionExpression convert = Expressions.lambda(bb.toBlock(), Collections.emptyList());
        return convert.compile().dynamicInvoke(new Object[0]);
    }

    private static class NonLiteralException
    extends Exception {
        private NonLiteralException() {
        }
    }
}

