/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.exec.AbstractExec;
import com.hazelcast.sql.impl.exec.IterationResult;
import com.hazelcast.sql.impl.exec.scan.KeyValueIterator;
import com.hazelcast.sql.impl.exec.scan.MapScanRow;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.predicate.TernaryLogic;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.row.EmptyRow;
import com.hazelcast.sql.impl.row.HeapRow;
import com.hazelcast.sql.impl.row.ListRowBatch;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.row.RowBatch;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.worker.QueryFragmentContext;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMapScanExec
extends AbstractExec {
    public static final int BATCH_SIZE = 1024;
    protected final String mapName;
    protected final QueryTargetDescriptor keyDescriptor;
    protected final QueryTargetDescriptor valueDescriptor;
    protected final List<QueryPath> fieldPaths;
    protected final List<QueryDataType> fieldTypes;
    protected final List<Integer> projects;
    protected final Expression<Boolean> filter;
    private final InternalSerializationService serializationService;
    private int migrationStamp;
    private KeyValueIterator recordIterator;
    private MapScanRow row;
    private List<Row> currentRows;

    protected AbstractMapScanExec(int id, String mapName, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, List<QueryPath> fieldPaths, List<QueryDataType> fieldTypes, List<Integer> projects, Expression<Boolean> filter, InternalSerializationService serializationService) {
        super(id);
        this.mapName = mapName;
        this.keyDescriptor = keyDescriptor;
        this.valueDescriptor = valueDescriptor;
        this.fieldPaths = fieldPaths;
        this.fieldTypes = fieldTypes;
        this.projects = projects;
        this.filter = filter;
        this.serializationService = serializationService;
    }

    @Override
    protected final void setup0(QueryFragmentContext ctx) {
        this.row = MapScanRow.create(this.keyDescriptor, this.valueDescriptor, this.fieldPaths, this.fieldTypes, this.createExtractors(), this.serializationService);
        this.migrationStamp = this.getMigrationStamp();
        this.recordIterator = this.createIterator();
    }

    @Override
    protected IterationResult advance0() {
        this.currentRows = null;
        while (this.recordIterator.tryAdvance()) {
            Row row = this.prepareRow(this.recordIterator.getKey(), this.recordIterator.getValue());
            if (row == null) continue;
            if (this.currentRows == null) {
                this.currentRows = new ArrayList<Row>(1024);
            }
            this.currentRows.add(row);
            if (this.currentRows.size() != 1024) continue;
            break;
        }
        boolean done = this.recordIterator.done();
        this.validateConsistency();
        if (!this.validateMigrationStamp(this.migrationStamp)) {
            throw QueryException.error(1005, "Map scan failed due to concurrent partition migration (result consistency cannot be guaranteed)").markInvalidate();
        }
        if (this.isDestroyed()) {
            throw QueryException.error(1006, "IMap has been destroyed concurrently: " + this.mapName).markInvalidate();
        }
        return done ? IterationResult.FETCHED_DONE : IterationResult.FETCHED;
    }

    protected void validateConsistency() {
    }

    @Override
    public RowBatch currentBatch0() {
        return this.currentRows != null ? new ListRowBatch(this.currentRows) : null;
    }

    protected abstract int getMigrationStamp();

    protected abstract boolean validateMigrationStamp(int var1);

    protected abstract KeyValueIterator createIterator();

    protected abstract boolean isDestroyed();

    protected Row prepareRow(Object rawKey, Object rawValue) {
        this.row.setKeyValue(rawKey, rawValue);
        if (this.filter != null && TernaryLogic.isNotTrue(this.filter.eval(this.row, this.ctx))) {
            return null;
        }
        if (this.projects.size() == 0) {
            return EmptyRow.INSTANCE;
        }
        HeapRow row = new HeapRow(this.projects.size());
        for (int j = 0; j < this.projects.size(); ++j) {
            Object projectRes = this.row.get(this.projects.get(j));
            row.set(j, projectRes);
        }
        return row;
    }

    protected abstract Extractors createExtractors();

    public QueryTargetDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    public QueryTargetDescriptor getValueDescriptor() {
        return this.valueDescriptor;
    }

    public List<QueryPath> getFieldPaths() {
        return this.fieldPaths;
    }

    public List<QueryDataType> getFieldTypes() {
        return this.fieldTypes;
    }

    public List<Integer> getProjects() {
        return this.projects;
    }

    public Expression<Boolean> getFilter() {
        return this.filter;
    }
}

