/*
 * Copyright (c) 2008-2020, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.Generated;
import com.hazelcast.client.impl.protocol.codec.builtin.*;
import com.hazelcast.client.impl.protocol.codec.custom.*;

import javax.annotation.Nullable;

import static com.hazelcast.client.impl.protocol.ClientMessage.*;
import static com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec.*;

/*
 * This file is auto-generated by the Hazelcast Client Protocol Code Generator.
 * To change this file, edit the templates or the protocol
 * definitions on the https://github.com/hazelcast/hazelcast-client-protocol
 * and regenerate it.
 */

/**
 * Reads the recorded metrics starting with the smallest sequence number
 * greater or equals to the sequence number set in fromSequence.
 */
@Generated("cccdf91e24c7a4dfce67d8d02ff99787")
public final class MCReadMetricsCodec {
    //hex: 0x200100
    public static final int REQUEST_MESSAGE_TYPE = 2097408;
    //hex: 0x200101
    public static final int RESPONSE_MESSAGE_TYPE = 2097409;
    private static final int REQUEST_UUID_FIELD_OFFSET = PARTITION_ID_FIELD_OFFSET + INT_SIZE_IN_BYTES;
    private static final int REQUEST_FROM_SEQUENCE_FIELD_OFFSET = REQUEST_UUID_FIELD_OFFSET + UUID_SIZE_IN_BYTES;
    private static final int REQUEST_INITIAL_FRAME_SIZE = REQUEST_FROM_SEQUENCE_FIELD_OFFSET + LONG_SIZE_IN_BYTES;
    private static final int RESPONSE_NEXT_SEQUENCE_FIELD_OFFSET = RESPONSE_BACKUP_ACKS_FIELD_OFFSET + BYTE_SIZE_IN_BYTES;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = RESPONSE_NEXT_SEQUENCE_FIELD_OFFSET + LONG_SIZE_IN_BYTES;

    private MCReadMetricsCodec() {
    }

    @edu.umd.cs.findbugs.annotations.SuppressFBWarnings({"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {

        /**
         * The UUID of the member that is supposed to read the metrics from.
         */
        public java.util.UUID uuid;

        /**
         * The sequence the recorded metrics should be read starting with.
         */
        public long fromSequence;
    }

    public static ClientMessage encodeRequest(java.util.UUID uuid, long fromSequence) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("MC.ReadMetrics");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[REQUEST_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, REQUEST_MESSAGE_TYPE);
        encodeInt(initialFrame.content, PARTITION_ID_FIELD_OFFSET, -1);
        encodeUUID(initialFrame.content, REQUEST_UUID_FIELD_OFFSET, uuid);
        encodeLong(initialFrame.content, REQUEST_FROM_SEQUENCE_FIELD_OFFSET, fromSequence);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static MCReadMetricsCodec.RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.uuid = decodeUUID(initialFrame.content, REQUEST_UUID_FIELD_OFFSET);
        request.fromSequence = decodeLong(initialFrame.content, REQUEST_FROM_SEQUENCE_FIELD_OFFSET);
        return request;
    }

    @edu.umd.cs.findbugs.annotations.SuppressFBWarnings({"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {

        /**
         * The map of timestamp and compressed metrics data
         */
        public java.util.List<java.util.Map.Entry<java.lang.Long, byte[]>> elements;

        /**
         * The sequence number that the next task should start with
         */
        public long nextSequence;
    }
    public static ClientMessage encodeResponse(java.util.Collection<java.util.Map.Entry<java.lang.Long, byte[]>> elements, long nextSequence) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[RESPONSE_INITIAL_FRAME_SIZE], UNFRAGMENTED_MESSAGE);
        encodeInt(initialFrame.content, TYPE_FIELD_OFFSET, RESPONSE_MESSAGE_TYPE);
        encodeLong(initialFrame.content, RESPONSE_NEXT_SEQUENCE_FIELD_OFFSET, nextSequence);
        clientMessage.add(initialFrame);

        EntryListLongByteArrayCodec.encode(clientMessage, elements);
        return clientMessage;
    }

    public static MCReadMetricsCodec.ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.nextSequence = decodeLong(initialFrame.content, RESPONSE_NEXT_SEQUENCE_FIELD_OFFSET);
        response.elements = EntryListLongByteArrayCodec.decode(iterator);
        return response;
    }

}
