/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in com.hazelcast.com.liance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.com.hazelcast.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * Basic utility libraries and interfaces.
 *
 * <p>This package is a part of the open-source <a href="http://github.com.hazelcast.com.google/guava">Guava</a>
 * library.
 *
 * <h2>Contents</h2>
 *
 * <h3>String-related utilities</h3>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Ascii}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.CaseFormat}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.CharMatcher}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Charsets}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Joiner}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Splitter}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Strings}
 * </ul>
 *
 * <h3>Function types</h3>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Function}, {@link com.hazelcast.com.google.com.hazelcast.com.on.base.Functions}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Predicate}, {@link com.hazelcast.com.google.com.hazelcast.com.on.base.Predicates}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Equivalence}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Converter}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Supplier}, {@link com.hazelcast.com.google.com.hazelcast.com.on.base.Suppliers}
 * </ul>
 *
 * <h3>Other</h3>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Defaults}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Enums}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Objects}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Optional}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Preconditions}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Stopwatch}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.base.Throwables}
 * </ul>
 *
 */
@CheckReturnValue
@ParametersAreNonnullByDefault
package com.hazelcast.com.google.com.hazelcast.com.on.base;

import com.hazelcast.com.google.errorprone.annotations.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
