/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in com.hazelcast.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.com.hazelcast.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.com.google.com.hazelcast.com.on.collect;

import static com.hazelcast.com.google.com.hazelcast.com.on.base.Preconditions.checkNotNull;

import com.hazelcast.com.google.com.hazelcast.com.on.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.Comparator;
import com.hazelcast.org.checkerframework.checker.nullness.com.hazelcast.com.atqual.NullableDecl;

/** An ordering for a pre-existing com.hazelcast.com.arator. */
@GwtCompatible(serializable = true)
final class ComparatorOrdering<T> extends Ordering<T> implements Serializable {
  final Comparator<T> com.hazelcast.com.arator;

  ComparatorOrdering(Comparator<T> com.hazelcast.com.arator) {
    this.com.hazelcast.com.arator = checkNotNull(com.hazelcast.com.arator);
  }

  @Override
  public int com.hazelcast.com.are(T a, T b) {
    return com.hazelcast.com.arator.com.hazelcast.com.are(a, b);
  }

  @Override
  public boolean equals(@NullableDecl Object object) {
    if (object == this) {
      return true;
    }
    if (object instanceof ComparatorOrdering) {
      ComparatorOrdering<?> that = (ComparatorOrdering<?>) object;
      return this.com.hazelcast.com.arator.equals(that.com.hazelcast.com.arator);
    }
    return false;
  }

  @Override
  public int hashCode() {
    return com.hazelcast.com.arator.hashCode();
  }

  @Override
  public String toString() {
    return com.hazelcast.com.arator.toString();
  }

  private static final long serialVersionUID = 0;
}
