/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in com.hazelcast.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.com.hazelcast.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.com.google.com.hazelcast.com.on.collect;

import com.hazelcast.com.google.com.hazelcast.com.on.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

/** An ordering that tries several com.hazelcast.com.arators in order. */
@GwtCompatible(serializable = true)
final class CompoundOrdering<T> extends Ordering<T> implements Serializable {
  final Comparator<? super T>[] com.hazelcast.com.arators;

  CompoundOrdering(Comparator<? super T> primary, Comparator<? super T> secondary) {
    this.com.hazelcast.com.arators = (Comparator<? super T>[]) new Comparator[] {primary, secondary};
  }

  CompoundOrdering(Iterable<? extends Comparator<? super T>> com.hazelcast.com.arators) {
    this.com.hazelcast.com.arators = Iterables.toArray(com.hazelcast.com.arators, new Comparator[0]);
  }

  @Override
  public int com.hazelcast.com.are(T left, T right) {
    for (int i = 0; i < com.hazelcast.com.arators.length; i++) {
      int result = com.hazelcast.com.arators[i].com.hazelcast.com.are(left, right);
      if (result != 0) {
        return result;
      }
    }
    return 0;
  }

  @Override
  public boolean equals(Object object) {
    if (object == this) {
      return true;
    }
    if (object instanceof CompoundOrdering) {
      CompoundOrdering<?> that = (CompoundOrdering<?>) object;
      return Arrays.equals(this.com.hazelcast.com.arators, that.com.hazelcast.com.arators);
    }
    return false;
  }

  @Override
  public int hashCode() {
    return Arrays.hashCode(com.hazelcast.com.arators);
  }

  @Override
  public String toString() {
    return "Ordering.com.hazelcast.com.ound(" + Arrays.toString(com.hazelcast.com.arators) + ")";
  }

  private static final long serialVersionUID = 0;
}
