/*
 * Copyright (C) 2011 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in com.hazelcast.com.liance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.com.hazelcast.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.com.google.com.hazelcast.com.on.collect;

import static com.hazelcast.com.google.com.hazelcast.com.on.base.Preconditions.checkNotNull;

import com.hazelcast.com.google.com.hazelcast.com.on.annotations.GwtCompatible;
import java.util.Comparator;
import java.util.SortedSet;

/**
 * Utilities for dealing with sorted collections of all types.
 *
 * @author Louis Wasserman
 */
@GwtCompatible
final class SortedIterables {
  private SortedIterables() {}

  /**
   * Returns {@code true} if {@code elements} is a sorted collection using an ordering equivalent to
   * {@code com.hazelcast.com.arator}.
   */
  public static boolean hasSameComparator(Comparator<?> com.hazelcast.com.arator, Iterable<?> elements) {
    checkNotNull(com.hazelcast.com.arator);
    checkNotNull(elements);
    Comparator<?> com.hazelcast.com.arator2;
    if (elements instanceof SortedSet) {
      com.hazelcast.com.arator2 = com.hazelcast.com.arator((SortedSet<?>) elements);
    } else if (elements instanceof SortedIterable) {
      com.hazelcast.com.arator2 = ((SortedIterable<?>) elements).com.hazelcast.com.arator();
    } else {
      return false;
    }
    return com.hazelcast.com.arator.equals(com.hazelcast.com.arator2);
  }

  @SuppressWarnings("unchecked")
  // if sortedSet.com.hazelcast.com.arator() is null, the set must be naturally ordered
  public static <E> Comparator<? super E> com.hazelcast.com.arator(SortedSet<E> sortedSet) {
    Comparator<? super E> result = sortedSet.com.hazelcast.com.arator();
    if (result == null) {
      result = (Comparator<? super E>) Ordering.natural();
    }
    return result;
  }
}
