/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in com.hazelcast.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.com.hazelcast.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains generic collection interfaces and implementations, and other utilities for
 * working with collections. It is a part of the open-source <a
 * href="http://github.com.hazelcast.com.google/guava">Guava</a> library.
 *
 * <h2>Collection Types</h2>
 *
 * <dl>
 *   <dt>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.BiMap}
 *   <dd>An extension of {@link java.util.Map} that guarantees the uniqueness of its values as well
 *       as that of its keys. This is sometimes called an "invertible map," since the restriction on
 *       values enables it to support an {@linkplain com.hazelcast.com.google.com.hazelcast.com.on.collect.BiMap#inverse inverse
 *       view} -- which is another instance of {@code BiMap}.
 *   <dt>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Multiset}
 *   <dd>An extension of {@link java.util.Collection} that may contain duplicate values like a
 *       {@link java.util.List}, yet has order-independent equality like a {@link java.util.Set}.
 *       One typical use for a multiset is to represent a histogram.
 *   <dt>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Multimap}
 *   <dd>A new type, which is similar to {@link java.util.Map}, but may contain multiple entries
 *       with the same key. Some behaviors of {@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Multimap} are left
 *       unspecified and are provided only by the subtypes mentioned below.
 *   <dt>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ListMultimap}
 *   <dd>An extension of {@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Multimap} which permits duplicate entries,
 *       supports random access of values for a particular key, and has <i>partially order-dependent
 *       equality</i> as defined by {@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ListMultimap#equals(Object)}.
 *       {@code ListMultimap} takes its name from the fact that the {@linkplain
 *       com.hazelcast.com.google.com.hazelcast.com.on.collect.ListMultimap#get collection of values} associated with a given
 *       key fulfills the {@link java.util.List} contract.
 *   <dt>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.SetMultimap}
 *   <dd>An extension of {@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Multimap} which has order-independent
 *       equality and does not allow duplicate entries; that is, while a key may appear twice in a
 *       {@code SetMultimap}, each must map to a different value. {@code SetMultimap} takes its name
 *       from the fact that the {@linkplain com.hazelcast.com.google.com.hazelcast.com.on.collect.SetMultimap#get collection of
 *       values} associated with a given key fulfills the {@link java.util.Set} contract.
 *   <dt>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.SortedSetMultimap}
 *   <dd>An extension of {@link com.hazelcast.com.google.com.hazelcast.com.on.collect.SetMultimap} for which the {@linkplain
 *       com.hazelcast.com.google.com.hazelcast.com.on.collect.SortedSetMultimap#get collection values} associated with a given
 *       key is a {@link java.util.SortedSet}.
 *   <dt>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Table}
 *   <dd>A new type, which is similar to {@link java.util.Map}, but which indexes its values by an
 *       ordered pair of keys, a row key and column key.
 *   <dt>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ClassToInstanceMap}
 *   <dd>An extension of {@link java.util.Map} that associates a raw type with an instance of that
 *       type.
 * </dl>
 *
 * <h2>Collection Implementations</h2>
 *
 * <h3>of {@link java.util.List}</h3>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableList}
 * </ul>
 *
 * <h3>of {@link java.util.Set}</h3>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableSet}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableSortedSet}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ContiguousSet} (see {@code Range})
 * </ul>
 *
 * <h3>of {@link java.util.Map}</h3>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableMap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableSortedMap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.MapMaker}
 * </ul>
 *
 * <h3>of {@link com.hazelcast.com.google.com.hazelcast.com.on.collect.BiMap}</h3>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableBiMap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.HashBiMap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.EnumBiMap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.EnumHashBiMap}
 * </ul>
 *
 * <h3>of {@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Multiset}</h3>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableMultiset}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.HashMultiset}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.LinkedHashMultiset}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.TreeMultiset}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.EnumMultiset}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ConcurrentHashMultiset}
 * </ul>
 *
 * <h3>of {@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Multimap}</h3>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableMultimap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableListMultimap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableSetMultimap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ArrayListMultimap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.HashMultimap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.TreeMultimap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.LinkedHashMultimap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.LinkedListMultimap}
 * </ul>
 *
 * <h3>of {@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Table}</h3>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableTable}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ArrayTable}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.HashBasedTable}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.TreeBasedTable}
 * </ul>
 *
 * <h3>of {@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ClassToInstanceMap}</h3>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableClassToInstanceMap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.MutableClassToInstanceMap}
 * </ul>
 *
 * <h2>Classes of static utility methods</h2>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Collections2}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Iterators}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Iterables}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Lists}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Maps}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Queues}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Sets}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Multisets}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Multimaps}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Tables}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ObjectArrays}
 * </ul>
 *
 * <h2>Comparison</h2>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Ordering}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ComparisonChain}
 * </ul>
 *
 * <h2>Abstract implementations</h2>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.AbstractIterator}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.AbstractSequentialIterator}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableCollection}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.UnmodifiableIterator}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.UnmodifiableListIterator}
 * </ul>
 *
 * <h2>Ranges</h2>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Range}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.RangeMap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.DiscreteDomain}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ContiguousSet}
 * </ul>
 *
 * <h2>Other</h2>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Interner}, {@link com.hazelcast.com.google.com.hazelcast.com.on.collect.Interners}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.MapDifference}, {@link
 *       com.hazelcast.com.google.com.hazelcast.com.on.collect.SortedMapDifference}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.MinMaxPriorityQueue}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.PeekingIterator}
 * </ul>
 *
 * <h2>Forwarding collections</h2>
 *
 * <ul>
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingCollection}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingConcurrentMap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingIterator}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingList}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingListIterator}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingListMultimap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingMap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingMapEntry}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingMultimap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingMultiset}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingNavigableMap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingNavigableSet}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingObject}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingQueue}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingSet}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingSetMultimap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingSortedMap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingSortedMultiset}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingSortedSet}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingSortedSetMultimap}
 *   <li>{@link com.hazelcast.com.google.com.hazelcast.com.on.collect.ForwardingTable}
 * </ul>
 */
@CheckReturnValue
@ParametersAreNonnullByDefault
package com.hazelcast.com.google.com.hazelcast.com.on.collect;

import com.hazelcast.com.google.errorprone.annotations.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
