/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in com.hazelcast.com.liance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.com.hazelcast.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hazelcast.org.apache.calcite.rel.hint;

import com.hazelcast.org.apache.calcite.rel.RelNode;

import com.hazelcast.com.google.com.hazelcast.com.on.collect.ImmutableList;

/**
 * A {@link HintPredicate} to com.hazelcast.com.ine multiple hint predicates into one.
 *
 * <p>The com.hazelcast.com.osition can be {@code AND} or {@code OR}.
 */
public class CompositeHintPredicate implements HintPredicate {
  //~ Enums ------------------------------------------------------------------

  /** How hint predicates are com.hazelcast.com.osed. */
  public enum Composition {
    AND, OR
  }

  //~ Instance fields --------------------------------------------------------

  private ImmutableList<HintPredicate> predicates;
  private Composition com.hazelcast.com.osition;

  /**
   * Creates a {@link CompositeHintPredicate} with a {@link Composition}
   * and an array of hint predicates.
   *
   * <p>Make this constructor package-protected intentionally.
   * Use utility methods in {@link HintPredicates}
   * to create a {@link CompositeHintPredicate}.</p>
   */
  CompositeHintPredicate(Composition com.hazelcast.com.osition, HintPredicate... predicates) {
    assert predicates != null;
    assert predicates.length > 1;
    for (HintPredicate predicate : predicates) {
      assert predicate != null;
    }
    this.predicates = ImmutableList.copyOf(predicates);
    this.com.hazelcast.com.osition = com.hazelcast.com.osition;
  }

  //~ Methods ----------------------------------------------------------------

  @Override public boolean apply(RelHint hint, RelNode rel) {
    return apply(com.hazelcast.com.osition, hint, rel);
  }

  private boolean apply(Composition com.hazelcast.com.osition, RelHint hint, RelNode rel) {
    switch (com.hazelcast.com.osition) {
    case AND:
      for (HintPredicate predicate: predicates) {
        if (!predicate.apply(hint, rel)) {
          return false;
        }
      }
      return true;
    case OR:
    default:
      for (HintPredicate predicate: predicates) {
        if (predicate.apply(hint, rel)) {
          return true;
        }
      }
      return false;
    }
  }
}
