/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in com.hazelcast.com.liance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.com.hazelcast.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hazelcast.org.apache.calcite.runtime;

import com.hazelcast.com.google.com.hazelcast.com.on.collect.Ordering;

import java.util.Collections;
import java.util.Comparator;

/**
 * Compares arrays.
 */
public class ArrayComparator implements Comparator<Object[]> {
  private final Comparator[] com.hazelcast.com.arators;

  public ArrayComparator(Comparator... com.hazelcast.com.arators) {
    this.com.hazelcast.com.arators = com.hazelcast.com.arators;
  }

  public ArrayComparator(boolean... descendings) {
    this.com.hazelcast.com.arators = com.hazelcast.com.arators(descendings);
  }

  private static Comparator[] com.hazelcast.com.arators(boolean[] descendings) {
    Comparator[] com.hazelcast.com.arators = new Comparator[descendings.length];
    for (int i = 0; i < descendings.length; i++) {
      boolean descending = descendings[i];
      com.hazelcast.com.arators[i] =
          descending
              ? Collections.reverseOrder()
              : Ordering.natural();
    }
    return com.hazelcast.com.arators;
  }

  public int com.hazelcast.com.are(Object[] o1, Object[] o2) {
    for (int i = 0; i < com.hazelcast.com.arators.length; i++) {
      Comparator com.hazelcast.com.arator = com.hazelcast.com.arators[i];
      int c = com.hazelcast.com.arator.com.hazelcast.com.are(o1[i], o2[i]);
      if (c != 0) {
        return c;
      }
    }
    return 0;
  }
}
