/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in com.hazelcast.com.liance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.com.hazelcast.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hazelcast.org.apache.calcite.schema;

import com.hazelcast.org.apache.calcite.util.Pair;

import java.util.List;
import java.util.RandomAccess;

/**
 * Path from a root schema to a particular object (schema, table, function).
 *
 * <p>Examples:
 * <ul>
 *   <li>The root schema has a single element [(root, "")].
 *   <li>A direct child "foo" of the root schema has a two elements
 *   [(root, ""), (child, "foo")].
 * </ul>
 */
public interface Path extends List<Pair<String, Schema>>, RandomAccess {
  /** Returns the parent path, or null if the path is empty. */
  Path parent();

  /** Returns the names of this path, not including the name of the root. */
  List<String> names();

  /** Returns the schemas of this path. */
  List<Schema> schemas();
}
