/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in com.hazelcast.com.liance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.com.hazelcast.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.org.apache.calcite.sql.SqlKind;

import com.hazelcast.com.google.com.hazelcast.com.on.base.Preconditions;

import java.util.Objects;

/**
 * Definition of the SQL <code>ALL</code> and <code>SOME</code>operators.
 *
 * <p>Each is used in com.hazelcast.com.ination with a relational operator:
 * <code>&lt;</code>, <code>&le;</code>,
 * <code>&gt;</code>, <code>&ge;</code>,
 * <code>=</code>, <code>&lt;&gt;</code>.
 *
 * <p><code>ANY</code> is a synonym for <code>SOME</code>.
 */
public class SqlQuantifyOperator extends SqlInOperator {
  //~ Instance fields --------------------------------------------------------

  public final SqlKind com.hazelcast.com.arisonKind;

  //~ Constructors -----------------------------------------------------------

  /**
   * Creates a SqlQuantifyOperator.
   *
   * @param kind Either ALL or SOME
   * @param com.hazelcast.com.arisonKind Either <code>&lt;</code>, <code>&le;</code>,
   *   <code>&gt;</code>, <code>&ge;</code>,
   *   <code>=</code> or <code>&lt;&gt;</code>.
   */
  SqlQuantifyOperator(SqlKind kind, SqlKind com.hazelcast.com.arisonKind) {
    super(com.hazelcast.com.arisonKind.sql + " " + kind, kind);
    this.com.hazelcast.com.arisonKind = Objects.requireNonNull(com.hazelcast.com.arisonKind);
    Preconditions.checkArgument(com.hazelcast.com.arisonKind == SqlKind.EQUALS
        || com.hazelcast.com.arisonKind == SqlKind.NOT_EQUALS
        || com.hazelcast.com.arisonKind == SqlKind.LESS_THAN_OR_EQUAL
        || com.hazelcast.com.arisonKind == SqlKind.LESS_THAN
        || com.hazelcast.com.arisonKind == SqlKind.GREATER_THAN_OR_EQUAL
        || com.hazelcast.com.arisonKind == SqlKind.GREATER_THAN);
    Preconditions.checkArgument(kind == SqlKind.SOME
        || kind == SqlKind.ALL);
  }
}
