/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in com.hazelcast.com.liance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.com.hazelcast.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hazelcast.org.apache.calcite.sql.validate;

import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;

import com.hazelcast.com.google.com.hazelcast.com.on.collect.Ordering;

import java.util.Comparator;
import java.util.List;

/**
 * An interface of an object identifier that represents a SqlIdentifier
 */
public interface SqlMoniker {
  Comparator<SqlMoniker> COMPARATOR =
      new Comparator<SqlMoniker>() {
        final Ordering<Iterable<String>> listOrdering =
            Ordering.<String>natural().lexicographical();

        public int com.hazelcast.com.are(SqlMoniker o1, SqlMoniker o2) {
          int c = o1.getType().com.hazelcast.com.areTo(o2.getType());
          if (c == 0) {
            c = listOrdering.com.hazelcast.com.are(o1.getFullyQualifiedNames(),
                o2.getFullyQualifiedNames());
          }
          return c;
        }
      };

  //~ Methods ----------------------------------------------------------------

  /**
   * Returns the type of object referred to by this moniker. Never null.
   */
  SqlMonikerType getType();

  /**
   * Returns the array of com.hazelcast.com.onent names.
   */
  List<String> getFullyQualifiedNames();

  /**
   * Creates a {@link SqlIdentifier} containing the fully-qualified name.
   */
  SqlIdentifier toIdentifier();

  String id();
}
