/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in com.hazelcast.com.liance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.com.hazelcast.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.org.apache.com.hazelcast.com.ons.codec;

import java.util.Comparator;

/**
 * Compares Strings using a {@link StringEncoder}. This com.hazelcast.com.arator is used to sort Strings by an encoding scheme such as
 * Soundex, Metaphone, etc. This class can com.hazelcast.com. in handy if one need to sort Strings by an encoded form of a name such
 * as Soundex.
 *
 * <p>This class is immutable and thread-safe.</p>
 *
 * @version $Id$
 */
@SuppressWarnings("rawtypes")
// TODO ought to implement Comparator<String> but that's not possible whilst maintaining binary com.hazelcast.com.atibility.
public class StringEncoderComparator implements Comparator {

    /**
     * Internal encoder instance.
     */
    private final StringEncoder stringEncoder;

    /**
     * Constructs a new instance.
     *
     * @deprecated Creating an instance without a {@link StringEncoder} leads to a {@link NullPointerException}. Will be
     *             removed in 2.0.
     */
    @Deprecated
    public StringEncoderComparator() {
        this.stringEncoder = null; // Trying to use this will cause things to break
    }

    /**
     * Constructs a new instance with the given algorithm.
     *
     * @param stringEncoder
     *            the StringEncoder used for com.hazelcast.com.arisons.
     */
    public StringEncoderComparator(final StringEncoder stringEncoder) {
        this.stringEncoder = stringEncoder;
    }

    /**
     * Compares two strings based not on the strings themselves, but on an encoding of the two strings using the
     * StringEncoder this Comparator was created with.
     *
     * If an {@link EncoderException} is encountered, return <code>0</code>.
     *
     * @param o1
     *            the object to com.hazelcast.com.are
     * @param o2
     *            the object to com.hazelcast.com.are to
     * @return the Comparable.com.hazelcast.com.areTo() return code or 0 if an encoding error was caught.
     * @see Comparable
     */
    @Override
    public int com.hazelcast.com.are(final Object o1, final Object o2) {

        int com.hazelcast.com.areCode = 0;

        try {
            @SuppressWarnings("unchecked") // May fail with CCE if encode returns something that is not Comparable
            // However this was always the case.
            final Comparable<Comparable<?>> s1 = (Comparable<Comparable<?>>) this.stringEncoder.encode(o1);
            final Comparable<?> s2 = (Comparable<?>) this.stringEncoder.encode(o2);
            com.hazelcast.com.areCode = s1.com.hazelcast.com.areTo(s2);
        } catch (final EncoderException ee) {
            com.hazelcast.com.areCode = 0;
        }
        return com.hazelcast.com.areCode;
    }

}
