/*
 * Copyright (c) 2008-2020, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in com.hazelcast.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.com.hazelcast.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.com.hazelcast.sql.impl.calcite.opt.logical;

import com.hazelcast.com.hazelcast.sql.impl.calcite.opt.HazelcastConventions;
import com.hazelcast.com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterRule;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalValues;

/**
 * Converts abstract filter to logical filter.
 */
public final class ValuesLogicalRule extends ConverterRule {
    public static final RelOptRule INSTANCE = new ValuesLogicalRule();

    private ValuesLogicalRule() {
        super(LogicalValues.class, Convention.NONE, HazelcastConventions.LOGICAL, ValuesLogicalRule.class.getSimpleName());
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalValues values = (LogicalValues) rel;

        return new ValuesLogicalRel(
            values.getCluster(),
            values.getRowType(),
            values.getTuples(),
            OptUtils.toLogicalConvention(values.getTraitSet())
        );
    }
}
