/*
 * Copyright (c) 2008-2020, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in com.hazelcast.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.com.hazelcast.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.com.hazelcast.sql.impl.calcite.validate.operators;

import com.hazelcast.com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.fun.SqlCastFunction;

import static com.hazelcast.com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeSystem.canCast;
import static com.hazelcast.org.apache.calcite.util.Static.RESOURCE;

/**
 * Custom Hazelcast {@link SqlCastFunction} to override the default operand type
 * checking strategy to make sure the casting behaviour is exactly the same as
 * defined by {@linkplain Converter converters}. Specifically, disallowing
 * conversions between BOOLEAN and numeric types both ways.
 */
public final class HazelcastSqlCastFunction extends SqlCastFunction {

    @Override
    public boolean checkOperandTypes(SqlCallBinding binding, boolean throwOnFailure) {
        RelDataType operand = binding.getOperandType(0);
        RelDataType targetType = binding.getOperandType(1);

        if (!canCast(operand, targetType)) {
            if (throwOnFailure) {
                throw binding.newError(RESOURCE.cannotCastValue(operand.toString(), targetType.toString()));
            }

            return false;
        }

        return super.checkOperandTypes(binding, throwOnFailure);
    }

}
