/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.materialize;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.ImmutableMap;
import com.hazelcast.org.apache.calcite.materialize.Lattice;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.pentaho.aggdes.algorithm.Algorithm;
import com.hazelcast.org.pentaho.aggdes.algorithm.Progress;
import com.hazelcast.org.pentaho.aggdes.algorithm.Result;
import com.hazelcast.org.pentaho.aggdes.algorithm.impl.MonteCarloAlgorithm;
import com.hazelcast.org.pentaho.aggdes.algorithm.util.ArgumentUtils;
import com.hazelcast.org.pentaho.aggdes.model.Aggregate;
import com.hazelcast.org.pentaho.aggdes.model.Attribute;
import com.hazelcast.org.pentaho.aggdes.model.Dialect;
import com.hazelcast.org.pentaho.aggdes.model.Dimension;
import com.hazelcast.org.pentaho.aggdes.model.Measure;
import com.hazelcast.org.pentaho.aggdes.model.Schema;
import com.hazelcast.org.pentaho.aggdes.model.StatisticsProvider;
import com.hazelcast.org.pentaho.aggdes.model.Table;
import java.io.PrintWriter;
import java.util.List;

public class TileSuggester {
    private final Lattice lattice;

    public TileSuggester(Lattice lattice) {
        this.lattice = lattice;
    }

    public Iterable<? extends Lattice.Tile> tiles() {
        MonteCarloAlgorithm algorithm = new MonteCarloAlgorithm();
        PrintWriter pw = Util.printWriter(System.out);
        ArgumentUtils.TextProgress progress = new ArgumentUtils.TextProgress(pw);
        StatisticsProviderImpl statisticsProvider = new StatisticsProviderImpl(this.lattice);
        double f = statisticsProvider.getFactRowCount();
        ImmutableMap.Builder<Algorithm.ParameterEnum, Number> map = ImmutableMap.builder();
        if (this.lattice.algorithmMaxMillis >= 0L) {
            map.put(Algorithm.ParameterEnum.timeLimitSeconds, Math.max(1, (int)(this.lattice.algorithmMaxMillis / 1000L)));
        }
        map.put(Algorithm.ParameterEnum.aggregateLimit, 3);
        map.put(Algorithm.ParameterEnum.costLimit, f * 5.0);
        SchemaImpl schema = new SchemaImpl(this.lattice, statisticsProvider);
        Result result = algorithm.run((Schema)schema, map.build(), (Progress)progress);
        ImmutableList.Builder tiles = ImmutableList.builder();
        for (Aggregate aggregate : result.getAggregates()) {
            tiles.add(this.toTile(aggregate));
        }
        return tiles.build();
    }

    private Lattice.Tile toTile(Aggregate aggregate) {
        Lattice.TileBuilder tileBuilder = new Lattice.TileBuilder();
        for (Lattice.Measure measure : this.lattice.defaultMeasures) {
            tileBuilder.addMeasure(measure);
        }
        for (Attribute attribute : aggregate.getAttributes()) {
            tileBuilder.addDimension(((AttributeImpl)attribute).column);
        }
        return tileBuilder.build();
    }

    private static class StatisticsProviderImpl
    implements StatisticsProvider {
        private final Lattice lattice;

        StatisticsProviderImpl(Lattice lattice) {
            this.lattice = lattice;
        }

        public double getFactRowCount() {
            return this.lattice.getFactRowCount();
        }

        public double getRowCount(List<Attribute> attributes) {
            return this.lattice.getRowCount(Util.transform(attributes, input -> ((AttributeImpl)input).column));
        }

        public double getSpace(List<Attribute> attributes) {
            return attributes.size();
        }

        public double getLoadTime(List<Attribute> attributes) {
            return this.getSpace(attributes) * this.getRowCount(attributes);
        }
    }

    private static class AttributeImpl
    implements Attribute {
        private final Lattice.Column column;
        private final TableImpl table;

        private AttributeImpl(Lattice.Column column, TableImpl table) {
            this.column = column;
            this.table = table;
        }

        public String toString() {
            return this.getLabel();
        }

        public String getLabel() {
            return this.column.alias;
        }

        public Table getTable() {
            return this.table;
        }

        public double estimateSpace() {
            return 0.0;
        }

        public String getCandidateColumnName() {
            return null;
        }

        public String getDatatype(Dialect dialect) {
            return null;
        }

        public List<Attribute> getAncestorAttributes() {
            return ImmutableList.of();
        }
    }

    private static class TableImpl
    implements Table {
        private TableImpl() {
        }

        public String getLabel() {
            return "TABLE";
        }

        public Table getParent() {
            return null;
        }
    }

    private static class SchemaImpl
    implements Schema {
        private final StatisticsProvider statisticsProvider;
        private final TableImpl table;
        private final ImmutableList<AttributeImpl> attributes;

        SchemaImpl(Lattice lattice, StatisticsProvider statisticsProvider) {
            this.statisticsProvider = statisticsProvider;
            this.table = new TableImpl();
            ImmutableList.Builder attributeBuilder = ImmutableList.builder();
            for (Lattice.Column column : lattice.columns) {
                attributeBuilder.add(new AttributeImpl(column, this.table));
            }
            this.attributes = attributeBuilder.build();
        }

        public List<? extends Table> getTables() {
            return ImmutableList.of(this.table);
        }

        public List<Measure> getMeasures() {
            throw new UnsupportedOperationException();
        }

        public List<? extends Dimension> getDimensions() {
            throw new UnsupportedOperationException();
        }

        public List<? extends Attribute> getAttributes() {
            return this.attributes;
        }

        public StatisticsProvider getStatisticsProvider() {
            return this.statisticsProvider;
        }

        public Dialect getDialect() {
            throw new UnsupportedOperationException();
        }

        public String generateAggregateSql(Aggregate aggregate, List<String> columnNameList) {
            throw new UnsupportedOperationException();
        }
    }
}

