/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rex;

import com.hazelcast.org.apache.calcite.config.CalciteSystemProperty;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexBiVisitor;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apiguardian.api.API;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class RexNode {
    private static final ThreadLocal<AtomicInteger> DESCRIBE_WITHOUT_NORMALIZE = ThreadLocal.withInitial(AtomicInteger::new);
    private static final Closeable DECREMENT_ON_CLOSE = () -> DESCRIBE_WITHOUT_NORMALIZE.get().decrementAndGet();
    private static final Closeable EMPTY = () -> {};
    protected String digest;

    @API(since="1.22", status=API.Status.EXPERIMENTAL)
    public static Closeable withNormalize(boolean needNormalize) {
        return needNormalize ? EMPTY : RexNode.skipNormalize();
    }

    @API(since="1.22", status=API.Status.EXPERIMENTAL)
    public static Closeable skipNormalize() {
        DESCRIBE_WITHOUT_NORMALIZE.get().incrementAndGet();
        return DECREMENT_ON_CLOSE;
    }

    @API(since="1.22", status=API.Status.EXPERIMENTAL)
    protected static boolean needNormalize() {
        return DESCRIBE_WITHOUT_NORMALIZE.get().get() == 0 && CalciteSystemProperty.ENABLE_REX_DIGEST_NORMALIZE.value() != false;
    }

    public abstract RelDataType getType();

    public boolean isAlwaysTrue() {
        return false;
    }

    public boolean isAlwaysFalse() {
        return false;
    }

    public boolean isA(SqlKind kind) {
        return this.getKind() == kind;
    }

    public boolean isA(Collection<SqlKind> kinds) {
        return this.getKind().belongsTo(kinds);
    }

    public SqlKind getKind() {
        return SqlKind.OTHER;
    }

    public String toString() {
        return this.digest;
    }

    @API(since="1.22", status=API.Status.EXPERIMENTAL)
    public String toStringRaw() {
        try (Closeable ignored = RexNode.skipNormalize();){
            String string = this.toString();
            return string;
        }
    }

    public int nodeCount() {
        return 1;
    }

    public abstract <R> R accept(RexVisitor<R> var1);

    public abstract <R, P> R accept(RexBiVisitor<R, P> var1, P var2);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @API(since="1.22", status=API.Status.EXPERIMENTAL)
    public static interface Closeable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

