/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec;

import com.hazelcast.sql.impl.exec.AbstractUpstreamAwareExec;
import com.hazelcast.sql.impl.exec.Exec;
import com.hazelcast.sql.impl.exec.IterationResult;
import com.hazelcast.sql.impl.row.ListRowBatch;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.row.RowBatch;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFilterExec
extends AbstractUpstreamAwareExec {
    static final int BATCH_SIZE = 1024;
    private List<Row> currentRows;
    private ListRowBatch currentBatch;

    protected AbstractFilterExec(int id, Exec upstream) {
        super(id, upstream);
    }

    @Override
    public IterationResult advance0() {
        if (this.currentRows == null) {
            this.currentRows = new ArrayList<Row>(1024);
            this.currentBatch = null;
        }
        int count = this.currentRows.size();
        do {
            if (!this.state.advance()) {
                return IterationResult.WAIT;
            }
            for (Row upstreamRow : this.state) {
                boolean matches = this.eval(upstreamRow);
                if (!matches) continue;
                this.currentRows.add(upstreamRow);
                if (++count != 1024) continue;
                return this.prepareBatch(this.state.isDone() ? IterationResult.FETCHED_DONE : IterationResult.FETCHED);
            }
        } while (!this.state.isDone());
        return this.prepareBatch(IterationResult.FETCHED_DONE);
    }

    private IterationResult prepareBatch(IterationResult result) {
        this.currentBatch = new ListRowBatch(this.currentRows);
        this.currentRows = null;
        return result;
    }

    @Override
    public RowBatch currentBatch0() {
        return this.currentBatch;
    }

    protected abstract boolean eval(Row var1);
}

