/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractWanPublisherConfig;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.AzureConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.EurekaConfig;
import com.hazelcast.config.GcpConfig;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.config.WanAcknowledgeType;
import com.hazelcast.config.WanQueueFullBehavior;
import com.hazelcast.config.WanSyncConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.wan.WanPublisher;
import com.hazelcast.wan.WanPublisherState;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class WanBatchPublisherConfig
extends AbstractWanPublisherConfig {
    public static final String DEFAULT_CLUSTER_NAME = "dev";
    public static final boolean DEFAULT_SNAPSHOT_ENABLED = false;
    public static final WanPublisherState DEFAULT_INITIAL_PUBLISHER_STATE = WanPublisherState.REPLICATING;
    public static final int DEFAULT_QUEUE_CAPACITY = 10000;
    public static final int DEFAULT_BATCH_SIZE = 500;
    public static final int DEFAULT_BATCH_MAX_DELAY_MILLIS = 1000;
    public static final int DEFAULT_RESPONSE_TIMEOUT_MILLIS = 60000;
    public static final WanQueueFullBehavior DEFAULT_QUEUE_FULL_BEHAVIOUR = WanQueueFullBehavior.DISCARD_AFTER_MUTATION;
    public static final WanAcknowledgeType DEFAULT_ACKNOWLEDGE_TYPE = WanAcknowledgeType.ACK_ON_OPERATION_COMPLETE;
    public static final int DEFAULT_DISCOVERY_PERIOD_SECONDS = 10;
    public static final int DEFAULT_MAX_TARGET_ENDPOINTS = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_CONCURRENT_INVOCATIONS = -1;
    public static final boolean DEFAULT_USE_ENDPOINT_PRIVATE_ADDRESS = false;
    public static final long DEFAULT_IDLE_MIN_PARK_NS = TimeUnit.MILLISECONDS.toNanos(10L);
    public static final long DEFAULT_IDLE_MAX_PARK_NS = TimeUnit.MILLISECONDS.toNanos(250L);
    public static final String DEFAULT_TARGET_ENDPOINTS = "";
    private String clusterName = "dev";
    private boolean snapshotEnabled = false;
    private WanPublisherState initialPublisherState = DEFAULT_INITIAL_PUBLISHER_STATE;
    private int queueCapacity = 10000;
    private int batchSize = 500;
    private int batchMaxDelayMillis = 1000;
    private int responseTimeoutMillis = 60000;
    private WanQueueFullBehavior queueFullBehavior = DEFAULT_QUEUE_FULL_BEHAVIOUR;
    private WanAcknowledgeType acknowledgeType = DEFAULT_ACKNOWLEDGE_TYPE;
    private int discoveryPeriodSeconds = 10;
    private int maxTargetEndpoints = Integer.MAX_VALUE;
    private int maxConcurrentInvocations = -1;
    private boolean useEndpointPrivateAddress = false;
    private long idleMinParkNs = DEFAULT_IDLE_MIN_PARK_NS;
    private long idleMaxParkNs = DEFAULT_IDLE_MAX_PARK_NS;
    private String targetEndpoints = "";
    private AwsConfig awsConfig = new AwsConfig();
    private GcpConfig gcpConfig = new GcpConfig();
    private AzureConfig azureConfig = new AzureConfig();
    private KubernetesConfig kubernetesConfig = new KubernetesConfig();
    private EurekaConfig eurekaConfig = new EurekaConfig();
    private DiscoveryConfig discoveryConfig = new DiscoveryConfig();
    private WanSyncConfig syncConfig = new WanSyncConfig();
    private String endpoint;

    public WanBatchPublisherConfig() {
        this.setClassName("com.hazelcast.enterprise.wan.impl.replication.WanBatchPublisher");
    }

    @Override
    public WanBatchPublisherConfig setClassName(@Nonnull String className) {
        super.setClassName(className);
        return this;
    }

    @Override
    public WanPublisher getImplementation() {
        return null;
    }

    @Override
    public WanBatchPublisherConfig setPublisherId(String publisherId) {
        super.setPublisherId(publisherId);
        return this;
    }

    @Override
    public WanBatchPublisherConfig setProperties(@Nonnull Map<String, Comparable> properties) {
        super.setProperties(properties);
        return this;
    }

    @Override
    public WanBatchPublisherConfig setImplementation(@Nonnull WanPublisher implementation) {
        return this;
    }

    @Nonnull
    public String getClusterName() {
        return this.clusterName;
    }

    public WanBatchPublisherConfig setClusterName(@Nonnull String clusterName) {
        this.clusterName = Preconditions.checkNotNull(clusterName, "Cluster name must not be null");
        return this;
    }

    public boolean isSnapshotEnabled() {
        return this.snapshotEnabled;
    }

    public WanBatchPublisherConfig setSnapshotEnabled(boolean snapshotEnabled) {
        this.snapshotEnabled = snapshotEnabled;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public WanBatchPublisherConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public int getBatchMaxDelayMillis() {
        return this.batchMaxDelayMillis;
    }

    public WanBatchPublisherConfig setBatchMaxDelayMillis(int batchMaxDelayMillis) {
        this.batchMaxDelayMillis = batchMaxDelayMillis;
        return this;
    }

    public int getResponseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    public WanBatchPublisherConfig setResponseTimeoutMillis(int responseTimeoutMillis) {
        this.responseTimeoutMillis = responseTimeoutMillis;
        return this;
    }

    @Nonnull
    public WanAcknowledgeType getAcknowledgeType() {
        return this.acknowledgeType;
    }

    public WanBatchPublisherConfig setAcknowledgeType(@Nonnull WanAcknowledgeType acknowledgeType) {
        this.acknowledgeType = Preconditions.checkNotNull(acknowledgeType, "Acknowledge type name must not be null");
        return this;
    }

    public String getTargetEndpoints() {
        return this.targetEndpoints;
    }

    public WanBatchPublisherConfig setTargetEndpoints(String targetEndpoints) {
        this.targetEndpoints = targetEndpoints;
        return this;
    }

    public WanSyncConfig getSyncConfig() {
        return this.syncConfig;
    }

    public WanBatchPublisherConfig setSyncConfig(WanSyncConfig syncConfig) {
        this.syncConfig = syncConfig;
        return this;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public WanBatchPublisherConfig setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
        return this;
    }

    @Nonnull
    public WanQueueFullBehavior getQueueFullBehavior() {
        return this.queueFullBehavior;
    }

    public WanBatchPublisherConfig setQueueFullBehavior(@Nonnull WanQueueFullBehavior queueFullBehavior) {
        this.queueFullBehavior = Preconditions.checkNotNull(queueFullBehavior, "Queue full behaviour must not be null");
        return this;
    }

    @Nonnull
    public WanPublisherState getInitialPublisherState() {
        return this.initialPublisherState;
    }

    public WanBatchPublisherConfig setInitialPublisherState(@Nonnull WanPublisherState initialPublisherState) {
        this.initialPublisherState = Preconditions.checkNotNull(initialPublisherState, "Initial WAN publisher state must not be null");
        return this;
    }

    public int getDiscoveryPeriodSeconds() {
        return this.discoveryPeriodSeconds;
    }

    public WanBatchPublisherConfig setDiscoveryPeriodSeconds(int discoveryPeriodSeconds) {
        this.discoveryPeriodSeconds = discoveryPeriodSeconds;
        return this;
    }

    public int getMaxTargetEndpoints() {
        return this.maxTargetEndpoints;
    }

    public WanBatchPublisherConfig setMaxTargetEndpoints(int maxTargetEndpoints) {
        this.maxTargetEndpoints = maxTargetEndpoints;
        return this;
    }

    public int getMaxConcurrentInvocations() {
        return this.maxConcurrentInvocations;
    }

    public WanBatchPublisherConfig setMaxConcurrentInvocations(int maxConcurrentInvocations) {
        this.maxConcurrentInvocations = maxConcurrentInvocations;
        return this;
    }

    public boolean isUseEndpointPrivateAddress() {
        return this.useEndpointPrivateAddress;
    }

    public WanBatchPublisherConfig setUseEndpointPrivateAddress(boolean useEndpointPrivateAddress) {
        this.useEndpointPrivateAddress = useEndpointPrivateAddress;
        return this;
    }

    public long getIdleMinParkNs() {
        return this.idleMinParkNs;
    }

    public WanBatchPublisherConfig setIdleMinParkNs(long idleMinParkNs) {
        this.idleMinParkNs = idleMinParkNs;
        return this;
    }

    public long getIdleMaxParkNs() {
        return this.idleMaxParkNs;
    }

    public WanBatchPublisherConfig setIdleMaxParkNs(long idleMaxParkNs) {
        this.idleMaxParkNs = idleMaxParkNs;
        return this;
    }

    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    public WanBatchPublisherConfig setAwsConfig(AwsConfig awsConfig) {
        this.awsConfig = Preconditions.isNotNull(awsConfig, "awsConfig");
        return this;
    }

    public GcpConfig getGcpConfig() {
        return this.gcpConfig;
    }

    public WanBatchPublisherConfig setGcpConfig(GcpConfig gcpConfig) {
        this.gcpConfig = Preconditions.isNotNull(gcpConfig, "gcpConfig");
        return this;
    }

    public AzureConfig getAzureConfig() {
        return this.azureConfig;
    }

    public WanBatchPublisherConfig setAzureConfig(AzureConfig azureConfig) {
        this.azureConfig = Preconditions.isNotNull(azureConfig, "azureConfig");
        return this;
    }

    public KubernetesConfig getKubernetesConfig() {
        return this.kubernetesConfig;
    }

    public WanBatchPublisherConfig setKubernetesConfig(KubernetesConfig kubernetesConfig) {
        this.kubernetesConfig = Preconditions.isNotNull(kubernetesConfig, "kubernetesConfig");
        return this;
    }

    public EurekaConfig getEurekaConfig() {
        return this.eurekaConfig;
    }

    public WanBatchPublisherConfig setEurekaConfig(EurekaConfig eurekaConfig) {
        this.eurekaConfig = Preconditions.isNotNull(eurekaConfig, "eurekaConfig");
        return this;
    }

    public DiscoveryConfig getDiscoveryConfig() {
        return this.discoveryConfig;
    }

    public WanBatchPublisherConfig setDiscoveryConfig(DiscoveryConfig discoveryConfig) {
        this.discoveryConfig = Preconditions.isNotNull(discoveryConfig, "discoveryProvidersConfig");
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public WanBatchPublisherConfig setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String toString() {
        return "WanBatchReplicationPublisherConfig{clusterName='" + this.clusterName + '\'' + ", publisherId='" + this.publisherId + '\'' + ", queueCapacity=" + this.queueCapacity + ", queueFullBehavior=" + (Object)((Object)this.queueFullBehavior) + ", initialPublisherState=" + (Object)((Object)this.initialPublisherState) + ", wanSyncConfig=" + this.syncConfig + ", properties=" + this.properties + ", className='" + this.className + '\'' + ", implementation=" + this.implementation + ", awsConfig=" + this.awsConfig + ", gcpConfig=" + this.gcpConfig + ", azureConfig=" + this.azureConfig + ", kubernetesConfig=" + this.kubernetesConfig + ", eurekaConfig=" + this.eurekaConfig + ", discoveryConfig=" + this.discoveryConfig + ", endpoint=" + this.endpoint + '}';
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeUTF(this.clusterName);
        out.writeBoolean(this.snapshotEnabled);
        out.writeByte(this.initialPublisherState.getId());
        out.writeInt(this.queueCapacity);
        out.writeInt(this.batchSize);
        out.writeInt(this.batchMaxDelayMillis);
        out.writeInt(this.responseTimeoutMillis);
        out.writeInt(this.queueFullBehavior.getId());
        out.writeInt(this.acknowledgeType.getId());
        out.writeInt(this.discoveryPeriodSeconds);
        out.writeInt(this.maxTargetEndpoints);
        out.writeInt(this.maxConcurrentInvocations);
        out.writeBoolean(this.useEndpointPrivateAddress);
        out.writeLong(this.idleMinParkNs);
        out.writeLong(this.idleMaxParkNs);
        out.writeUTF(this.targetEndpoints);
        out.writeObject(this.awsConfig);
        out.writeObject(this.gcpConfig);
        out.writeObject(this.azureConfig);
        out.writeObject(this.kubernetesConfig);
        out.writeObject(this.eurekaConfig);
        out.writeObject(this.discoveryConfig);
        out.writeObject(this.syncConfig);
        out.writeUTF(this.endpoint);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.clusterName = in.readUTF();
        this.snapshotEnabled = in.readBoolean();
        this.initialPublisherState = WanPublisherState.getByType(in.readByte());
        this.queueCapacity = in.readInt();
        this.batchSize = in.readInt();
        this.batchMaxDelayMillis = in.readInt();
        this.responseTimeoutMillis = in.readInt();
        this.queueFullBehavior = WanQueueFullBehavior.getByType(in.readInt());
        this.acknowledgeType = WanAcknowledgeType.getById(in.readInt());
        this.discoveryPeriodSeconds = in.readInt();
        this.maxTargetEndpoints = in.readInt();
        this.maxConcurrentInvocations = in.readInt();
        this.useEndpointPrivateAddress = in.readBoolean();
        this.idleMinParkNs = in.readLong();
        this.idleMaxParkNs = in.readLong();
        this.targetEndpoints = in.readUTF();
        this.awsConfig = (AwsConfig)in.readObject();
        this.gcpConfig = (GcpConfig)in.readObject();
        this.azureConfig = (AzureConfig)in.readObject();
        this.kubernetesConfig = (KubernetesConfig)in.readObject();
        this.eurekaConfig = (EurekaConfig)in.readObject();
        this.discoveryConfig = (DiscoveryConfig)in.readObject();
        this.syncConfig = (WanSyncConfig)in.readObject();
        this.endpoint = in.readUTF();
    }
}

