/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.JetBuildInfo;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.BiConsumer;

class BuildInfoCollector
implements MetricsCollector {
    BuildInfoCollector() {
    }

    @Override
    public void forEachMetric(Node node, BiConsumer<PhoneHomeMetrics, String> metricsConsumer) {
        BuildInfo imdgInfo = node.getBuildInfo();
        JetBuildInfo jetInfo = imdgInfo.getJetBuildInfo();
        metricsConsumer.accept(PhoneHomeMetrics.HAZELCAST_DOWNLOAD_ID, this.getDownloadId());
        metricsConsumer.accept(PhoneHomeMetrics.JAVA_VERSION_OF_SYSTEM, System.getProperty("java.version"));
        metricsConsumer.accept(PhoneHomeMetrics.BUILD_VERSION, imdgInfo.getVersion());
        metricsConsumer.accept(PhoneHomeMetrics.JET_BUILD_VERSION, jetInfo == null ? "" : jetInfo.getVersion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDownloadId() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("hazelcast-download.properties");){
            if (is == null) return "source";
            Properties properties = new Properties();
            properties.load(is);
            String string = properties.getProperty("hazelcastDownloadId");
            return string;
        }
        catch (IOException ignored) {
            EmptyStatement.ignore(ignored);
        }
        return "source";
    }
}

