/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import java.util.Map;
import java.util.function.BiConsumer;

class ClientInfoCollector
implements MetricsCollector {
    ClientInfoCollector() {
    }

    @Override
    public void forEachMetric(Node node, BiConsumer<PhoneHomeMetrics, String> metricsConsumer) {
        Map<String, Integer> clients = node.clientEngine.getConnectedClientStats();
        metricsConsumer.accept(PhoneHomeMetrics.CLIENTS_WITH_CPP_CONNECTION, Integer.toString(clients.getOrDefault("CPP", 0)));
        metricsConsumer.accept(PhoneHomeMetrics.CLIENTS_WITH_CSHARP_CONNECTION, Integer.toString(clients.getOrDefault("CSP", 0)));
        metricsConsumer.accept(PhoneHomeMetrics.CLIENTS_WITH_JAVA_CONNECTION, Integer.toString(clients.getOrDefault("JVM", 0)));
        metricsConsumer.accept(PhoneHomeMetrics.CLIENTS_WITH_NODEJS_CONNECTION, Integer.toString(clients.getOrDefault("NJS", 0)));
        metricsConsumer.accept(PhoneHomeMetrics.CLIENTS_WITH_PYTHON_CONNECTION, Integer.toString(clients.getOrDefault("PYH", 0)));
        metricsConsumer.accept(PhoneHomeMetrics.CLIENTS_WITH_GO_CONNECTION, Integer.toString(clients.getOrDefault("GOO", 0)));
        metricsConsumer.accept(PhoneHomeMetrics.CLIENT_ENDPOINT_COUNT, MetricsCollector.convertToLetter(node.clientEngine.getClientEndpointCount()));
    }
}

