/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

class DistributedObjectCounterCollector
implements MetricsCollector {
    private static final Map<String, PhoneHomeMetrics> SERVICE_NAME_TO_METRIC_NAME = new HashMap<String, PhoneHomeMetrics>();

    DistributedObjectCounterCollector() {
    }

    @Override
    public void forEachMetric(Node node, BiConsumer<PhoneHomeMetrics, String> metricsConsumer) {
        Collection<DistributedObject> objects = node.hazelcastInstance.getDistributedObjects();
        Map<String, Long> objectsPerService = objects.stream().filter(obj -> SERVICE_NAME_TO_METRIC_NAME.containsKey(obj.getServiceName())).collect(Collectors.groupingBy(DistributedObject::getServiceName, Collectors.counting()));
        SERVICE_NAME_TO_METRIC_NAME.forEach((serviceName, metricName) -> metricsConsumer.accept((PhoneHomeMetrics)((Object)metricName), String.valueOf(objectsPerService.getOrDefault(serviceName, 0L))));
    }

    static {
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:mapService", PhoneHomeMetrics.COUNT_OF_MAPS);
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:setService", PhoneHomeMetrics.COUNT_OF_SETS);
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:queueService", PhoneHomeMetrics.COUNT_OF_QUEUES);
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:multiMapService", PhoneHomeMetrics.COUNT_OF_MULTIMAPS);
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:listService", PhoneHomeMetrics.COUNT_OF_LISTS);
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:ringbufferService", PhoneHomeMetrics.COUNT_OF_RING_BUFFERS);
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:cacheService", PhoneHomeMetrics.COUNT_OF_CACHES);
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:topicService", PhoneHomeMetrics.COUNT_OF_TOPICS);
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:replicatedMapService", PhoneHomeMetrics.COUNT_OF_REPLICATED_MAPS);
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:cardinalityEstimatorService", PhoneHomeMetrics.COUNT_OF_CARDINALITY_ESTIMATORS);
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:PNCounterService", PhoneHomeMetrics.COUNT_OF_PN_COUNTERS);
        SERVICE_NAME_TO_METRIC_NAME.put("hz:impl:flakeIdGeneratorService", PhoneHomeMetrics.COUNT_OF_FLAKE_ID_GENERATORS);
    }
}

