/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConsistencyCheckStrategy;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanSyncConfig;
import com.hazelcast.internal.eviction.EvictionPolicyEvaluatorProvider;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MemoryInfoAccessor;
import com.hazelcast.internal.util.RuntimeMemoryInfoAccessor;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.impl.InterceptorRegistry;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.eviction.EvictionChecker;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.eviction.EvictorImpl;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.MapStoreContextFactory;
import com.hazelcast.map.impl.query.QueryEntryFactory;
import com.hazelcast.map.impl.record.DataRecordFactory;
import com.hazelcast.map.impl.record.ObjectRecordFactory;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.wan.impl.DelegatingWanScheme;
import com.hazelcast.wan.impl.WanReplicationService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class MapContainer {
    protected final String name;
    protected final String splitBrainProtectionName;
    protected final Indexes globalIndexes;
    protected final Extractors extractors;
    protected final MapStoreContext mapStoreContext;
    protected final ObjectNamespace objectNamespace;
    protected final MapServiceContext mapServiceContext;
    protected final QueryEntryFactory queryEntryFactory;
    protected final EventJournalConfig eventJournalConfig;
    protected final PartitioningStrategy partitioningStrategy;
    protected final InternalSerializationService serializationService;
    protected final Function<Object, Data> toDataFunction = new ObjectToData();
    protected final InterceptorRegistry interceptorRegistry = new InterceptorRegistry();
    protected final ConstructorFunction<Void, RecordFactory> recordFactoryConstructor;
    protected final AtomicInteger invalidationListenerCount = new AtomicInteger();
    protected SplitBrainMergePolicy wanMergePolicy;
    protected DelegatingWanScheme wanReplicationDelegate;
    protected volatile MapConfig mapConfig;
    private volatile Evictor evictor;
    private boolean persistWanReplicatedData;
    private volatile boolean destroyed;

    public MapContainer(String name, Config config, MapServiceContext mapServiceContext) {
        this.name = name;
        this.mapConfig = config.findMapConfig(name);
        this.eventJournalConfig = this.mapConfig.getEventJournalConfig();
        this.mapServiceContext = mapServiceContext;
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        this.partitioningStrategy = this.createPartitioningStrategy();
        this.splitBrainProtectionName = this.mapConfig.getSplitBrainProtectionName();
        this.serializationService = (InternalSerializationService)nodeEngine.getSerializationService();
        this.recordFactoryConstructor = this.createRecordFactoryConstructor(this.serializationService);
        this.objectNamespace = MapService.getObjectNamespace(name);
        this.extractors = Extractors.newBuilder(this.serializationService).setAttributeConfigs(this.mapConfig.getAttributeConfigs()).setClassLoader(nodeEngine.getConfigClassLoader()).build();
        this.queryEntryFactory = new QueryEntryFactory(this.mapConfig.getCacheDeserializedValues(), this.serializationService, this.extractors);
        this.globalIndexes = this.shouldUseGlobalIndex() ? this.createIndexes(true) : null;
        this.mapStoreContext = MapStoreContextFactory.createMapStoreContext(this);
        this.initWanReplication(mapServiceContext.getNodeEngine());
    }

    public void init() {
        this.initEvictor();
        this.mapStoreContext.start();
    }

    public Indexes createIndexes(boolean global) {
        int partitionCount = this.mapServiceContext.getNodeEngine().getPartitionService().getPartitionCount();
        return Indexes.newBuilder(this.serializationService, this.mapServiceContext.getIndexCopyBehavior(), this.mapConfig.getInMemoryFormat()).global(global).extractors(this.extractors).statsEnabled(this.mapConfig.isStatisticsEnabled()).indexProvider(this.mapServiceContext.getIndexProvider(this.mapConfig)).usesCachedQueryableEntries(this.mapConfig.getCacheDeserializedValues() != CacheDeserializedValues.NEVER).partitionCount(partitionCount).resultFilter(this::hasNotExpired).build();
    }

    private boolean hasNotExpired(QueryableEntry queryableEntry) {
        Data keyData = queryableEntry.getKeyData();
        IPartitionService partitionService = this.mapServiceContext.getNodeEngine().getPartitionService();
        int partitionId = partitionService.getPartitionId(keyData);
        if (!this.getIndexes(partitionId).isGlobal()) {
            ThreadUtil.assertRunningOnPartitionThread();
        }
        if (!partitionService.isPartitionOwner(partitionId)) {
            return false;
        }
        RecordStore recordStore = this.mapServiceContext.getExistingRecordStore(partitionId, this.name);
        return recordStore != null && !recordStore.expireOrAccess(keyData);
    }

    public final void initEvictor() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        EvictionPolicyComparator evictionPolicyComparator = EvictionPolicyEvaluatorProvider.getEvictionPolicyComparator(this.mapConfig.getEvictionConfig(), nodeEngine.getConfigClassLoader());
        this.evictor = evictionPolicyComparator != null ? this.newEvictor(evictionPolicyComparator, nodeEngine.getProperties().getInteger(ClusterProperty.MAP_EVICTION_BATCH_SIZE), nodeEngine.getPartitionService()) : Evictor.NULL_EVICTOR;
    }

    protected Evictor newEvictor(EvictionPolicyComparator evictionPolicyComparator, int evictionBatchSize, IPartitionService partitionService) {
        EvictionChecker evictionChecker = new EvictionChecker(MapContainer.getMemoryInfoAccessor(), this.mapServiceContext);
        return new EvictorImpl(evictionPolicyComparator, evictionChecker, evictionBatchSize, partitionService);
    }

    public boolean shouldUseGlobalIndex() {
        return this.mapConfig.getInMemoryFormat() != InMemoryFormat.NATIVE || this.mapServiceContext.globalIndexEnabled();
    }

    protected static MemoryInfoAccessor getMemoryInfoAccessor() {
        MemoryInfoAccessor pluggedMemoryInfoAccessor = MapContainer.getPluggedMemoryInfoAccessor();
        return pluggedMemoryInfoAccessor != null ? pluggedMemoryInfoAccessor : new RuntimeMemoryInfoAccessor();
    }

    private static MemoryInfoAccessor getPluggedMemoryInfoAccessor() {
        String memoryInfoAccessorImpl = System.getProperty("hazelcast.memory.info.accessor.impl");
        if (memoryInfoAccessorImpl == null) {
            return null;
        }
        try {
            return (MemoryInfoAccessor)ClassLoaderUtil.newInstance(null, memoryInfoAccessorImpl);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    ConstructorFunction<Void, RecordFactory> createRecordFactoryConstructor(SerializationService serializationService) {
        return anyArg -> {
            switch (this.mapConfig.getInMemoryFormat()) {
                case BINARY: {
                    return new DataRecordFactory(this, serializationService);
                }
                case OBJECT: {
                    return new ObjectRecordFactory(this, serializationService);
                }
            }
            throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.mapConfig.getInMemoryFormat()));
        };
    }

    public void initWanReplication(NodeEngine nodeEngine) {
        WanConsumerConfig wanConsumerConfig;
        WanReplicationRef wanReplicationRef = this.mapConfig.getWanReplicationRef();
        if (wanReplicationRef == null) {
            return;
        }
        String wanReplicationRefName = wanReplicationRef.getName();
        Config config = nodeEngine.getConfig();
        if (!this.mapConfig.getMerkleTreeConfig().isEnabled() && this.hasPublisherWithMerkleTreeSync(config, wanReplicationRefName)) {
            throw new InvalidConfigurationException("Map " + this.name + " has disabled merkle trees but the WAN replication scheme " + wanReplicationRefName + " has publishers that use merkle trees. Please enable merkle trees for the map.");
        }
        WanReplicationService wanReplicationService = nodeEngine.getWanReplicationService();
        this.wanReplicationDelegate = wanReplicationService.getWanReplicationPublishers(wanReplicationRefName);
        this.wanMergePolicy = nodeEngine.getSplitBrainMergePolicyProvider().getMergePolicy(wanReplicationRef.getMergePolicyClassName());
        WanReplicationConfig wanReplicationConfig = config.getWanReplicationConfig(wanReplicationRefName);
        if (wanReplicationConfig != null && (wanConsumerConfig = wanReplicationConfig.getConsumerConfig()) != null) {
            this.persistWanReplicatedData = wanConsumerConfig.isPersistWanReplicatedData();
        }
    }

    private boolean hasPublisherWithMerkleTreeSync(Config config, String wanReplicationRefName) {
        WanReplicationConfig replicationConfig = config.getWanReplicationConfig(wanReplicationRefName);
        if (replicationConfig == null) {
            return false;
        }
        return replicationConfig.getBatchPublisherConfigs().stream().anyMatch(c -> {
            WanSyncConfig syncConfig = c.getSyncConfig();
            return syncConfig != null && ConsistencyCheckStrategy.MERKLE_TREES.equals((Object)syncConfig.getConsistencyCheckStrategy());
        });
    }

    private PartitioningStrategy createPartitioningStrategy() {
        return this.mapServiceContext.getPartitioningStrategy(this.mapConfig.getName(), this.mapConfig.getPartitioningStrategyConfig());
    }

    public Indexes getIndexes() {
        return this.globalIndexes;
    }

    public Indexes getIndexes(int partitionId) {
        if (this.globalIndexes != null) {
            return this.globalIndexes;
        }
        return this.mapServiceContext.getPartitionContainer(partitionId).getIndexes(this.name);
    }

    public boolean isGlobalIndexEnabled() {
        return this.globalIndexes != null;
    }

    public DelegatingWanScheme getWanReplicationDelegate() {
        return this.wanReplicationDelegate;
    }

    public SplitBrainMergePolicy getWanMergePolicy() {
        return this.wanMergePolicy;
    }

    public boolean isWanReplicationEnabled() {
        return this.wanReplicationDelegate != null && this.wanMergePolicy != null;
    }

    public boolean isWanRepublishingEnabled() {
        return this.isWanReplicationEnabled() && this.mapConfig.getWanReplicationRef().isRepublishingEnabled();
    }

    public int getTotalBackupCount() {
        return this.getBackupCount() + this.getAsyncBackupCount();
    }

    public int getBackupCount() {
        return this.mapConfig.getBackupCount();
    }

    public int getAsyncBackupCount() {
        return this.mapConfig.getAsyncBackupCount();
    }

    public PartitioningStrategy getPartitioningStrategy() {
        return this.partitioningStrategy;
    }

    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    public MapStoreContext getMapStoreContext() {
        return this.mapStoreContext;
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public void setMapConfig(MapConfig mapConfig) {
        this.mapConfig = mapConfig;
    }

    public EventJournalConfig getEventJournalConfig() {
        return this.eventJournalConfig;
    }

    public String getName() {
        return this.name;
    }

    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    public Function<Object, Data> toData() {
        return this.toDataFunction;
    }

    public ConstructorFunction<Void, RecordFactory> getRecordFactoryConstructor() {
        return this.recordFactoryConstructor;
    }

    public QueryableEntry newQueryEntry(Data key, Object value) {
        return this.queryEntryFactory.newEntry(key, value);
    }

    public Evictor getEvictor() {
        return this.evictor;
    }

    public void setEvictor(Evictor evictor) {
        this.evictor = evictor;
    }

    public Extractors getExtractors() {
        return this.extractors;
    }

    public boolean hasInvalidationListener() {
        return this.invalidationListenerCount.get() > 0;
    }

    public void increaseInvalidationListenerCount() {
        this.invalidationListenerCount.incrementAndGet();
    }

    public void decreaseInvalidationListenerCount() {
        this.invalidationListenerCount.decrementAndGet();
    }

    public InterceptorRegistry getInterceptorRegistry() {
        return this.interceptorRegistry;
    }

    public void onBeforeDestroy() {
        this.destroyed = true;
    }

    public void onDestroy() {
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean shouldCloneOnEntryProcessing(int partitionId) {
        return this.getIndexes(partitionId).haveAtLeastOneIndex() && InMemoryFormat.OBJECT.equals((Object)this.mapConfig.getInMemoryFormat());
    }

    public ObjectNamespace getObjectNamespace() {
        return this.objectNamespace;
    }

    public Map<String, IndexConfig> getIndexDefinitions() {
        HashMap<String, IndexConfig> definitions = new HashMap<String, IndexConfig>();
        if (this.isGlobalIndexEnabled()) {
            for (InternalIndex index : this.globalIndexes.getIndexes()) {
                definitions.put(index.getName(), index.getConfig());
            }
        } else {
            for (PartitionContainer container : this.mapServiceContext.getPartitionContainers()) {
                for (InternalIndex index : container.getIndexes(this.name).getIndexes()) {
                    definitions.put(index.getName(), index.getConfig());
                }
            }
        }
        return definitions;
    }

    public boolean isPersistWanReplicatedData() {
        return this.persistWanReplicatedData;
    }

    private class ObjectToData
    implements Function<Object, Data> {
        private ObjectToData() {
        }

        @Override
        public Data apply(Object input) {
            SerializationService ss = MapContainer.this.mapStoreContext.getSerializationService();
            return ss.toData(input, MapContainer.this.partitioningStrategy);
        }
    }
}

