/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.eviction;

import com.hazelcast.core.EntryView;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.impl.eviction.EvictionChecker;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.LazyEvictableEntryView;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryReason;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;

public class EvictorImpl
implements Evictor {
    protected final EvictionChecker evictionChecker;
    protected final EvictionPolicyComparator policy;
    protected final IPartitionService partitionService;
    private final int batchSize;

    public EvictorImpl(EvictionPolicyComparator policy, EvictionChecker evictionChecker, int batchSize, IPartitionService partitionService) {
        this.evictionChecker = Preconditions.checkNotNull(evictionChecker);
        this.partitionService = Preconditions.checkNotNull(partitionService);
        this.policy = Preconditions.checkNotNull(policy);
        this.batchSize = batchSize;
    }

    @Override
    public void evict(RecordStore recordStore, Data excludedKey) {
        ThreadUtil.assertRunningOnPartitionThread();
        long now = EvictorImpl.getNow();
        boolean backup = this.isBackup(recordStore);
        for (int i = 0; i < this.batchSize; ++i) {
            EntryView entryView = this.selectEvictableEntry(recordStore, excludedKey, now, backup);
            if (entryView == null) {
                return;
            }
            this.evictEntry(recordStore, entryView, now, backup);
        }
    }

    @Override
    public void forceEvictByPercentage(RecordStore recordStore, double evictionPercentage) {
    }

    private EntryView selectEvictableEntry(RecordStore recordStore, Data excludedKey, long now, boolean backup) {
        EntryView excluded = null;
        EntryView selected = null;
        for (EntryView current : this.getRandomSamples(recordStore)) {
            Data dataKey = this.getDataKeyFromEntryView(current);
            if (recordStore.isExpired(dataKey, now, backup)) {
                return current;
            }
            if (excludedKey != null && excluded == null && dataKey.equals(excludedKey)) {
                excluded = current;
                continue;
            }
            if (selected != null && this.policy.compare(current, selected) >= 0) continue;
            selected = current;
        }
        return selected == null ? excluded : selected;
    }

    private void evictEntry(RecordStore recordStore, EntryView selectedEntry, long now, boolean backup) {
        Data dataKey = this.getDataKeyFromEntryView(selectedEntry);
        if (recordStore.isLocked(dataKey)) {
            return;
        }
        ExpiryReason expiryReason = recordStore.hasExpired(dataKey, now, backup);
        Object value = recordStore.evict(dataKey, backup);
        if (!backup) {
            recordStore.doPostEvictionOperations(dataKey, value, expiryReason);
        }
    }

    @Override
    public boolean checkEvictable(RecordStore recordStore) {
        ThreadUtil.assertRunningOnPartitionThread();
        return this.evictionChecker.checkEvictable(recordStore);
    }

    protected Record getRecordFromEntryView(EntryView evictableEntryView) {
        return ((LazyEvictableEntryView)evictableEntryView).getRecord();
    }

    protected Data getDataKeyFromEntryView(EntryView selectedEntry) {
        return ((LazyEvictableEntryView)selectedEntry).getDataKey();
    }

    protected boolean isBackup(RecordStore recordStore) {
        int partitionId = recordStore.getPartitionId();
        IPartition partition = this.partitionService.getPartition(partitionId, false);
        return !partition.isLocal();
    }

    protected Iterable<EntryView> getRandomSamples(RecordStore recordStore) {
        Storage storage = recordStore.getStorage();
        return storage.getRandomSamples(SAMPLE_COUNT);
    }

    protected static long getNow() {
        return Clock.currentTimeMillis();
    }

    public String toString() {
        return "EvictorImpl{, evictionPolicyComparator=" + this.policy + ", batchSize=" + this.batchSize + '}';
    }
}

