/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.record.CachedSimpleRecord;
import com.hazelcast.map.impl.record.RecordReaderWriter;

class CachedSimpleRecordWithLRUEviction
extends CachedSimpleRecord {
    private int lastAccessTime;

    CachedSimpleRecordWithLRUEviction(Data value) {
        super(value);
    }

    CachedSimpleRecordWithLRUEviction() {
    }

    @Override
    public long getLastAccessTime() {
        return this.recomputeWithBaseTime(this.lastAccessTime);
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = this.stripBaseTime(lastAccessTime);
    }

    @Override
    public int getRawLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void setRawLastAccessTime(int lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @Override
    public long getCost() {
        return super.getCost() + 4L;
    }

    @Override
    public void onAccess(long now) {
        this.onAccessSafe(now);
    }

    @Override
    public void onAccessSafe(long now) {
        this.setLastAccessTime(now);
    }

    @Override
    public RecordReaderWriter getMatchingRecordReaderWriter() {
        return RecordReaderWriter.SIMPLE_DATA_RECORD_WITH_LRU_EVICTION_READER_WRITER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CachedSimpleRecordWithLRUEviction that = (CachedSimpleRecordWithLRUEviction)o;
        return this.lastAccessTime == that.lastAccessTime;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.lastAccessTime;
        return result;
    }

    @Override
    public String toString() {
        return "CachedSimpleRecordWithLRUEviction{lastAccessTime=" + this.lastAccessTime + "} " + super.toString();
    }
}

