/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.CachedDataRecordWithStats;
import com.hazelcast.map.impl.record.CachedSimpleRecord;
import com.hazelcast.map.impl.record.CachedSimpleRecordWithLFUEviction;
import com.hazelcast.map.impl.record.CachedSimpleRecordWithLRUEviction;
import com.hazelcast.map.impl.record.DataRecordWithStats;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.record.SimpleRecordWithLFUEviction;
import com.hazelcast.map.impl.record.SimpleRecordWithLRUEviction;

public class DataRecordFactory
implements RecordFactory<Data> {
    private final MapContainer mapContainer;
    private final SerializationService ss;

    public DataRecordFactory(MapContainer mapContainer, SerializationService ss) {
        this.ss = ss;
        this.mapContainer = mapContainer;
    }

    @Override
    public Record<Data> newRecord(Object value) {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        boolean perEntryStatsEnabled = mapConfig.isPerEntryStatsEnabled();
        CacheDeserializedValues cacheDeserializedValues = mapConfig.getCacheDeserializedValues();
        boolean hasEviction = this.mapContainer.getEvictor() != Evictor.NULL_EVICTOR;
        Object valueData = this.ss.toData(value);
        switch (cacheDeserializedValues) {
            case NEVER: {
                return this.newSimpleRecord((Data)valueData, mapConfig, perEntryStatsEnabled, hasEviction);
            }
        }
        return this.newCachedSimpleRecord((Data)valueData, mapConfig, perEntryStatsEnabled, hasEviction);
    }

    @Override
    public MapContainer geMapContainer() {
        return this.mapContainer;
    }

    private Record<Data> newCachedSimpleRecord(Data valueData, MapConfig mapConfig, boolean perEntryStatsEnabled, boolean hasEviction) {
        if (perEntryStatsEnabled || this.isClusterV41()) {
            return new CachedDataRecordWithStats(valueData);
        }
        if (hasEviction) {
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LRU) {
                return new CachedSimpleRecordWithLRUEviction(valueData);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LFU) {
                return new CachedSimpleRecordWithLFUEviction(valueData);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.RANDOM) {
                return new CachedSimpleRecord(valueData);
            }
            return new CachedDataRecordWithStats(valueData);
        }
        return new CachedSimpleRecord(valueData);
    }

    private Record<Data> newSimpleRecord(Data valueData, MapConfig mapConfig, boolean perEntryStatsEnabled, boolean hasEviction) {
        if (perEntryStatsEnabled || this.isClusterV41()) {
            return new DataRecordWithStats(valueData);
        }
        if (hasEviction) {
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LRU) {
                return new SimpleRecordWithLRUEviction<Data>(valueData);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.LFU) {
                return new SimpleRecordWithLFUEviction<Data>(valueData);
            }
            if (mapConfig.getEvictionConfig().getEvictionPolicy() == EvictionPolicy.RANDOM) {
                return new CachedSimpleRecord(valueData);
            }
            return new DataRecordWithStats(valueData);
        }
        return new CachedSimpleRecord(valueData);
    }
}

