/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.TimeUtil;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import java.util.concurrent.TimeUnit;

public interface Record<V> {
    public static final long EPOCH_TIME = TimeUtil.zeroOutMs(1514764800000L);
    public static final int UNSET = -1;
    public static final Object NOT_CACHED = new Object();

    public V getValue();

    public void setValue(V var1);

    public long getCost();

    public int getVersion();

    public void setVersion(int var1);

    public Object getCachedValueUnsafe();

    public boolean casCachedValue(Object var1, Object var2);

    public long getLastAccessTime();

    public void setLastAccessTime(long var1);

    public long getLastUpdateTime();

    public void setLastUpdateTime(long var1);

    public long getCreationTime();

    public void setCreationTime(long var1);

    public int getHits();

    public void setHits(int var1);

    public long getLastStoredTime();

    public void setLastStoredTime(long var1);

    public long getSequence();

    public void setSequence(long var1);

    default public long recomputeWithBaseTime(int value) {
        if (value == -1) {
            return 0L;
        }
        long exploded = TimeUnit.SECONDS.toMillis(value);
        return exploded + EPOCH_TIME;
    }

    default public int stripBaseTime(long value) {
        int diff = -1;
        if (value > 0L) {
            diff = (int)TimeUnit.MILLISECONDS.toSeconds(value - EPOCH_TIME);
        }
        return diff;
    }

    default public void onAccess(long now) {
        int hits = this.getHits();
        if (hits < Integer.MAX_VALUE) {
            this.setHits(hits + 1);
        }
        this.onAccessSafe(now);
    }

    default public void onAccessSafe(long now) {
        this.setLastAccessTime(now);
    }

    default public void onUpdate(long now) {
        this.setVersion(this.getVersion() + 1);
        this.setLastUpdateTime(now);
    }

    default public void onStore() {
        this.setLastStoredTime(Clock.currentTimeMillis());
    }

    public RecordReaderWriter getMatchingRecordReaderWriter();

    public int getRawCreationTime();

    public void setRawCreationTime(int var1);

    public int getRawLastAccessTime();

    public void setRawLastAccessTime(int var1);

    public int getRawLastUpdateTime();

    public void setRawLastUpdateTime(int var1);

    public int getRawLastStoredTime();

    public void setRawLastStoredTime(int var1);
}

