/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import java.util.Objects;

class SimpleRecord<V>
implements Record<V> {
    protected volatile V value;
    private int version;

    SimpleRecord() {
    }

    SimpleRecord(V value) {
        this.setValue(value);
    }

    @Override
    public final int getVersion() {
        return this.version;
    }

    @Override
    public final void setVersion(int version) {
        this.version = version;
    }

    @Override
    public long getLastAccessTime() {
        return -1L;
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
    }

    @Override
    public long getLastUpdateTime() {
        return -1L;
    }

    @Override
    public void setLastUpdateTime(long lastUpdateTime) {
    }

    @Override
    public long getCreationTime() {
        return -1L;
    }

    @Override
    public void setCreationTime(long creationTime) {
    }

    @Override
    public int getHits() {
        return -1;
    }

    @Override
    public void setHits(int hits) {
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V value) {
        this.value = value;
    }

    @Override
    public Object getCachedValueUnsafe() {
        return Record.NOT_CACHED;
    }

    @Override
    public boolean casCachedValue(Object expectedValue, Object newValue) {
        return true;
    }

    @Override
    public final long getSequence() {
        return -1L;
    }

    @Override
    public final void setSequence(long sequence) {
    }

    @Override
    public long getLastStoredTime() {
        return -1L;
    }

    @Override
    public void setLastStoredTime(long lastStoredTime) {
    }

    @Override
    public long getCost() {
        if (this.value instanceof Data) {
            return JVMUtil.OBJECT_HEADER_SIZE + JVMUtil.REFERENCE_COST_IN_BYTES + ((Data)this.value).getHeapCost();
        }
        return 0L;
    }

    @Override
    public void onAccess(long now) {
    }

    @Override
    public void onAccessSafe(long now) {
    }

    @Override
    public void onStore() {
    }

    @Override
    public int getRawCreationTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRawCreationTime(int creationTime) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRawLastAccessTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRawLastAccessTime(int lastAccessTime) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRawLastUpdateTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRawLastUpdateTime(int lastUpdateTime) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRawLastStoredTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRawLastStoredTime(int time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RecordReaderWriter getMatchingRecordReaderWriter() {
        return RecordReaderWriter.SIMPLE_DATA_RECORD_READER_WRITER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleRecord that = (SimpleRecord)o;
        if (this.version != that.version) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        return "SimpleRecord{value=" + this.value + ", version=" + this.version + '}';
    }
}

