/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore.expiry;

import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.eviction.ClearExpiredRecordsTask;
import com.hazelcast.internal.eviction.ExpiredKey;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationQueue;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.ExpirationTimeSetter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadataImpl;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryReason;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class ExpirySystem {
    private static final long DEFAULT_EXPIRED_KEY_SCAN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final String PROP_EXPIRED_KEY_SCAN_TIMEOUT_NANOS = "hazelcast.internal.map.expired.key.scan.timeout.nanos";
    private static final HazelcastProperty EXPIRED_KEY_SCAN_TIMEOUT_NANOS = new HazelcastProperty("hazelcast.internal.map.expired.key.scan.timeout.nanos", DEFAULT_EXPIRED_KEY_SCAN_TIMEOUT_NANOS, TimeUnit.NANOSECONDS);
    private static final int ONE_HUNDRED_PERCENT = 100;
    private static final int MIN_SCANNABLE_ENTRY_COUNT = 100;
    private final long expiryDelayMillis;
    private final long expiredKeyScanTimeoutNanos;
    private final boolean canPrimaryDriveExpiration;
    private final ILogger logger;
    private final RecordStore recordStore;
    private final MapContainer mapContainer;
    private final MapServiceContext mapServiceContext;
    private final ClearExpiredRecordsTask clearExpiredRecordsTask;
    private final InvalidationQueue<ExpiredKey> expiredKeys = new InvalidationQueue();
    private Iterator<Map.Entry<Data, ExpiryMetadata>> cachedExpirationIterator;
    private Map<Data, ExpiryMetadata> expireTimeByKey;

    public ExpirySystem(RecordStore recordStore, MapContainer mapContainer, MapServiceContext mapServiceContext) {
        this.recordStore = recordStore;
        this.clearExpiredRecordsTask = mapServiceContext.getExpirationManager().getTask();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        this.logger = nodeEngine.getLogger(this.getClass());
        HazelcastProperties hazelcastProperties = nodeEngine.getProperties();
        this.expiryDelayMillis = hazelcastProperties.getMillis(ClusterProperty.MAP_EXPIRY_DELAY_SECONDS);
        this.mapContainer = mapContainer;
        this.mapServiceContext = mapServiceContext;
        this.canPrimaryDriveExpiration = mapServiceContext.getClearExpiredRecordsTask().canPrimaryDriveExpiration();
        this.expiredKeyScanTimeoutNanos = nodeEngine.getProperties().getNanos(EXPIRED_KEY_SCAN_TIMEOUT_NANOS);
    }

    public boolean isEmpty() {
        return MapUtil.isNullOrEmpty(this.expireTimeByKey);
    }

    protected Map<Data, ExpiryMetadata> createExpiryTimeByKeyMap() {
        return new ConcurrentHashMap<Data, ExpiryMetadata>();
    }

    public void clear() {
        Map<Data, ExpiryMetadata> map = this.getOrCreateExpireTimeByKeyMap(false);
        map.clear();
    }

    protected Map<Data, ExpiryMetadata> getOrCreateExpireTimeByKeyMap(boolean createIfAbsent) {
        if (this.expireTimeByKey != null) {
            return this.expireTimeByKey;
        }
        if (createIfAbsent) {
            this.expireTimeByKey = this.createExpiryTimeByKeyMap();
            return this.expireTimeByKey;
        }
        return Collections.emptyMap();
    }

    protected ExpiryMetadata createExpiryMetadata(long ttlMillis, long maxIdleMillis, long expirationTime) {
        return new ExpiryMetadataImpl(ttlMillis, maxIdleMillis, expirationTime);
    }

    public void addKeyIfExpirable(Data key, long ttl, long maxIdle, long expiryTime, long now) {
        if (expiryTime <= 0L) {
            MapConfig mapConfig = this.mapContainer.getMapConfig();
            long ttlMillis = ExpirationTimeSetter.pickTTLMillis(ttl, mapConfig);
            long maxIdleMillis = ExpirationTimeSetter.pickMaxIdleMillis(maxIdle, mapConfig);
            long expirationTime = ExpirationTimeSetter.calculateExpirationTime(ttlMillis, maxIdleMillis, now);
            this.addExpirableKey(key, ttlMillis, maxIdleMillis, expirationTime);
        } else {
            this.addExpirableKey(key, ttl, maxIdle, expiryTime);
        }
    }

    private void addExpirableKey(Data key, long ttlMillis, long maxIdleMillis, long expirationTime) {
        if (expirationTime == Long.MAX_VALUE) {
            Map<Data, ExpiryMetadata> map = this.getOrCreateExpireTimeByKeyMap(false);
            if (!map.isEmpty()) {
                Data nativeKey = this.recordStore.getStorage().toBackingDataKeyFormat(key);
                this.callRemove(nativeKey, this.expireTimeByKey);
            }
            return;
        }
        Map<Data, ExpiryMetadata> expireTimeByKey = this.getOrCreateExpireTimeByKeyMap(true);
        ExpiryMetadata expiryMetadata = expireTimeByKey.get(key);
        if (expiryMetadata == null) {
            expiryMetadata = this.createExpiryMetadata(ttlMillis, maxIdleMillis, expirationTime);
            Data nativeKey = this.recordStore.getStorage().toBackingDataKeyFormat(key);
            expireTimeByKey.put(nativeKey, expiryMetadata);
        } else {
            expiryMetadata.setTtl(ttlMillis).setMaxIdle(maxIdleMillis).setExpirationTime(expirationTime);
        }
        this.mapServiceContext.getExpirationManager().scheduleExpirationTask();
    }

    public long calculateExpirationTime(long ttl, long maxIdle, long now) {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        long ttlMillis = ExpirationTimeSetter.pickTTLMillis(ttl, mapConfig);
        long maxIdleMillis = ExpirationTimeSetter.pickMaxIdleMillis(maxIdle, mapConfig);
        return ExpirationTimeSetter.calculateExpirationTime(ttlMillis, maxIdleMillis, now);
    }

    public void removeKeyFromExpirySystem(Data key) {
        Map<Data, ExpiryMetadata> expireTimeByKey = this.getOrCreateExpireTimeByKeyMap(false);
        if (expireTimeByKey.isEmpty()) {
            return;
        }
        this.callRemove(key, expireTimeByKey);
    }

    public void extendExpiryTime(Data dataKey, long now) {
        if (this.isEmpty()) {
            return;
        }
        Map<Data, ExpiryMetadata> expireTimeByKey = this.getOrCreateExpireTimeByKeyMap(false);
        if (expireTimeByKey.isEmpty()) {
            return;
        }
        ExpiryMetadata expiryMetadata = this.getExpiryMetadataForExpiryCheck(dataKey, expireTimeByKey);
        if (expiryMetadata == null || expiryMetadata.getMaxIdle() == Long.MAX_VALUE) {
            return;
        }
        long expirationTime = ExpirationTimeSetter.calculateExpirationTime(expiryMetadata.getTtl(), expiryMetadata.getMaxIdle(), now);
        expiryMetadata.setExpirationTime(expirationTime);
    }

    public ExpiryReason hasExpired(Data key, long now, boolean backup) {
        Map<Data, ExpiryMetadata> expireTimeByKey = this.getOrCreateExpireTimeByKeyMap(false);
        if (expireTimeByKey.isEmpty()) {
            return ExpiryReason.NOT_EXPIRED;
        }
        ExpiryMetadata expiryMetadata = this.getExpiryMetadataForExpiryCheck(key, expireTimeByKey);
        return this.hasExpired(expiryMetadata, now, backup);
    }

    private ExpiryReason hasExpired(ExpiryMetadata expiryMetadata, long now, boolean backup) {
        ExpiryReason expiryReason;
        long nextExpirationTime;
        if (expiryMetadata == null) {
            return ExpiryReason.NOT_EXPIRED;
        }
        long l = nextExpirationTime = backup ? expiryMetadata.getExpirationTime() + this.expiryDelayMillis : expiryMetadata.getExpirationTime();
        if (nextExpirationTime > now) {
            return ExpiryReason.NOT_EXPIRED;
        }
        ExpiryReason expiryReason2 = expiryReason = expiryMetadata.getMaxIdle() <= expiryMetadata.getTtl() ? ExpiryReason.MAX_IDLE_SECONDS : ExpiryReason.TTL;
        if (backup && this.canPrimaryDriveExpiration && expiryReason == ExpiryReason.MAX_IDLE_SECONDS) {
            return ExpiryReason.NOT_EXPIRED;
        }
        return expiryReason;
    }

    public InvalidationQueue<ExpiredKey> getExpiredKeys() {
        return this.expiredKeys;
    }

    @Nonnull
    public ExpiryMetadata getExpiredMetadata(Data key) {
        ExpiryMetadata expiryMetadata = this.getOrCreateExpireTimeByKeyMap(false).get(key);
        return expiryMetadata != null ? expiryMetadata : ExpiryMetadata.NULL;
    }

    public void evictExpiredEntries(int percentage, long now, boolean backup) {
        Map<Data, ExpiryMetadata> expireTimeByKey = this.getOrCreateExpireTimeByKeyMap(false);
        if (expireTimeByKey.isEmpty()) {
            return;
        }
        int expirableKeysMapSize = expireTimeByKey.size();
        int keyCountInPercentage = (int)(1.0 * (double)expirableKeysMapSize * (double)percentage / 100.0);
        int maxScannableKeyCount = Math.max(100, keyCountInPercentage);
        this.scanAndEvictExpiredKeys(maxScannableKeyCount, now, backup);
        this.accumulateOrSendExpiredKey(null);
    }

    private Iterator<Map.Entry<Data, ExpiryMetadata>> getOrInitCachedIterator() {
        if (this.cachedExpirationIterator == null || !this.cachedExpirationIterator.hasNext()) {
            this.cachedExpirationIterator = this.initIteratorOf(this.expireTimeByKey);
        }
        return this.cachedExpirationIterator;
    }

    private void scanAndEvictExpiredKeys(int maxScannableKeyCount, long now, boolean backup) {
        Data key;
        long scanLoopStartNanos = System.nanoTime();
        ArrayList<Object> expiredKeyExpiryReasonList = new ArrayList<Object>();
        int scannedKeyCount = 0;
        int expiredKeyCount = 0;
        do {
            Map.Entry<Data, ExpiryMetadata> entry = this.getOrInitCachedIterator().next();
            ++scannedKeyCount;
            key = entry.getKey();
            ExpiryMetadata expiryMetadata = entry.getValue();
            ExpiryReason expiryReason = this.hasExpired(expiryMetadata, now, backup);
            if (expiryReason == ExpiryReason.NOT_EXPIRED || this.recordStore.isLocked(key)) continue;
            expiredKeyExpiryReasonList.add(key);
            expiredKeyExpiryReasonList.add((Object)expiryReason);
            this.callIterRemove(this.cachedExpirationIterator);
            ++expiredKeyCount;
        } while ((scannedKeyCount % Evictor.SAMPLE_COUNT != 0 || System.nanoTime() - scanLoopStartNanos < this.expiredKeyScanTimeoutNanos) && scannedKeyCount < maxScannableKeyCount && this.getOrInitCachedIterator().hasNext());
        for (int i = 0; i < expiredKeyExpiryReasonList.size(); i += 2) {
            key = (Data)expiredKeyExpiryReasonList.get(i);
            ExpiryReason reason = (ExpiryReason)((Object)expiredKeyExpiryReasonList.get(i + 1));
            this.recordStore.evictExpiredEntryAndPublishExpiryEvent(key, reason, backup);
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("mapName: %s, partitionId: %d, partitionSize: %d, remainingKeyCountToExpire: %d, maxScannableKeyCount: %d, scannedKeyCount: %d, expiredKeyCount: %d", this.recordStore.getName(), this.recordStore.getPartitionId(), this.recordStore.size(), this.expireTimeByKey.size(), maxScannableKeyCount, scannedKeyCount, expiredKeyCount));
        }
    }

    protected ExpiryMetadata getExpiryMetadataForExpiryCheck(Data key, Map<Data, ExpiryMetadata> expireTimeByKey) {
        return expireTimeByKey.get(key);
    }

    protected void callIterRemove(Iterator<Map.Entry<Data, ExpiryMetadata>> expirationIterator) {
        expirationIterator.remove();
    }

    protected Iterator<Map.Entry<Data, ExpiryMetadata>> initIteratorOf(Map<Data, ExpiryMetadata> expireTimeByKey) {
        return expireTimeByKey.entrySet().iterator();
    }

    protected void callRemove(Data key, Map<Data, ExpiryMetadata> expireTimeByKey) {
        expireTimeByKey.remove(key);
    }

    public void destroy() {
        this.getOrCreateExpireTimeByKeyMap(false).clear();
    }

    public void accumulateOrSendExpiredKey(Data dataKey) {
        if (this.mapContainer.getTotalBackupCount() == 0) {
            return;
        }
        if (dataKey != null) {
            this.expiredKeys.offer(new ExpiredKey(ToHeapDataConverter.toHeapData(dataKey), -1L));
        }
        this.clearExpiredRecordsTask.tryToSendBackupExpiryOp(this.recordStore, true);
    }
}

