/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rex;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexBiVisitor;
import com.hazelcast.org.apache.calcite.rex.RexSlot;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import java.util.List;
import java.util.Objects;

public class RexLocalRef
extends RexSlot {
    private static final List<String> NAMES = new RexSlot.SelfPopulatingList("$t", 30);

    public RexLocalRef(int index, RelDataType type) {
        super(RexLocalRef.createName(index), index, type);
        assert (type != null);
        assert (index >= 0);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.LOCAL_REF;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof RexLocalRef && Objects.equals(this.type, ((RexLocalRef)obj).type) && this.index == ((RexLocalRef)obj).index;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.index);
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitLocalRef(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitLocalRef(this, arg);
    }

    private static String createName(int index) {
        return NAMES.get(index);
    }
}

