/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite;

import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.runtime.CalciteContextException;
import com.hazelcast.org.apache.calcite.runtime.Resources;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorException;
import com.hazelcast.org.apache.calcite.sql2rel.SqlRexConvertletTable;
import com.hazelcast.org.apache.calcite.sql2rel.SqlToRelConverter;
import com.hazelcast.org.apache.calcite.util.TimeString;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.calcite.validate.HazelcastResources;
import com.hazelcast.sql.impl.calcite.validate.literal.Literal;
import com.hazelcast.sql.impl.calcite.validate.literal.LiteralUtils;
import com.hazelcast.sql.impl.calcite.validate.operators.HazelcastReturnTypeInference;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.converter.BigDecimalConverter;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class HazelcastSqlToRelConverter
extends SqlToRelConverter {
    private final Set<SqlNode> callSet = Collections.newSetFromMap(new IdentityHashMap());

    public HazelcastSqlToRelConverter(RelOptTable.ViewExpander viewExpander, SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable, SqlToRelConverter.Config config) {
        super(viewExpander, validator, catalogReader, cluster, convertletTable, config);
    }

    @Override
    protected RexNode convertExtendedExpression(SqlNode node, SqlToRelConverter.Blackboard blackboard) {
        if (node.getKind() == SqlKind.LITERAL) {
            return this.convertLiteral((SqlLiteral)node);
        }
        if (node.getKind() == SqlKind.CAST) {
            return this.convertCast((SqlCall)node, blackboard);
        }
        if (node instanceof SqlCall) {
            return this.convertCall(node, blackboard);
        }
        return null;
    }

    private RexNode convertLiteral(SqlLiteral literal) {
        RelDataType type = this.validator.getValidatedNodeType(literal);
        return this.getRexBuilder().makeLiteral(literal.getValue(), type, true);
    }

    private RexNode convertCast(SqlCall call, SqlToRelConverter.Blackboard blackboard) {
        Object operand = call.operand(0);
        RexNode convertedOperand = blackboard.convertExpression((SqlNode)operand);
        RelDataType from = this.validator.getValidatedNodeType((SqlNode)operand);
        RelDataType to = this.validator.getValidatedNodeType(call);
        QueryDataType fromType = HazelcastTypeUtils.toHazelcastType(from.getSqlTypeName());
        QueryDataType toType = HazelcastTypeUtils.toHazelcastType(to.getSqlTypeName());
        Literal literal = LiteralUtils.literal(operand);
        if (literal != null && literal.getTypeName() != SqlTypeName.NULL) {
            try {
                toType.getConverter().convertToSelf(fromType.getConverter(), literal.getValue());
            }
            catch (Exception e) {
                throw HazelcastSqlToRelConverter.literalConversionException(this.validator, call, literal, toType, e);
            }
            if (SqlTypeName.CHAR_TYPES.contains((Object)to.getSqlTypeName())) {
                return this.getRexBuilder().makeLiteral(literal.getStringValue(), to, true);
            }
            if (SqlTypeName.CHAR_TYPES.contains((Object)from.getSqlTypeName()) && to.getSqlTypeName() == SqlTypeName.TIME) {
                LocalTime time = fromType.getConverter().asTime(literal.getStringValue());
                TimeString timeString = new TimeString(time.getHour(), time.getMinute(), time.getSecond());
                return this.getRexBuilder().makeLiteral((Object)timeString, to, true);
            }
            if (fromType.getTypeFamily().isNumeric() && toType.getTypeFamily().isNumericApproximate()) {
                BigDecimal originalValue = ((SqlLiteral)operand).getValueAs(BigDecimal.class);
                Object convertedValue = toType.getConverter().convertToSelf(BigDecimalConverter.INSTANCE, originalValue);
                return this.getRexBuilder().makeLiteral(convertedValue, to, false);
            }
        }
        return this.getRexBuilder().makeCast(to, convertedOperand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RexNode convertCall(SqlNode node, SqlToRelConverter.Blackboard blackboard) {
        if (node.getKind() == SqlKind.DEFAULT) {
            return null;
        }
        if (this.callSet.add(node)) {
            try {
                RexNode rexNode;
                RelDataType type = this.validator.getValidatedNodeType(node);
                HazelcastReturnTypeInference.push(type);
                try {
                    rexNode = blackboard.convertExpression(node);
                }
                catch (Throwable throwable) {
                    HazelcastReturnTypeInference.pop();
                    throw throwable;
                }
                HazelcastReturnTypeInference.pop();
                return rexNode;
            }
            finally {
                this.callSet.remove(node);
            }
        }
        return null;
    }

    private static QueryException literalConversionException(SqlValidator validator, SqlCall call, Literal literal, QueryDataType toType, Exception e) {
        String literalValue = literal.getStringValue();
        if (SqlTypeName.CHAR_TYPES.contains((Object)literal.getTypeName())) {
            literalValue = "'" + literalValue + "'";
        }
        Resources.ExInst<SqlValidatorException> contextError = HazelcastResources.RESOURCES.cannotCastLiteralValue(literalValue, toType.getTypeFamily().getPublicType().name(), e.getMessage());
        CalciteContextException calciteContextError = validator.newValidationError(call, contextError);
        throw QueryException.error(1008, calciteContextError.getMessage(), calciteContextError);
    }
}

