/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNumericLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorTable;
import com.hazelcast.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import com.hazelcast.org.apache.calcite.sql.validate.SelectScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformance;
import com.hazelcast.org.apache.calcite.sql.validate.SqlQualified;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorImplBridge;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorTable;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.sql.impl.ParameterConverter;
import com.hazelcast.sql.impl.calcite.parse.UnsupportedOperationVisitor;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlOperatorTable;
import com.hazelcast.sql.impl.calcite.validate.literal.LiteralUtils;
import com.hazelcast.sql.impl.calcite.validate.param.StrictParameterConverter;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeCoercion;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HazelcastSqlValidator
extends SqlValidatorImplBridge {
    private static final SqlValidator.Config CONFIG = SqlValidator.Config.DEFAULT.withIdentifierExpansion(true);
    private final HazelcastSqlOperatorTable.RewriteVisitor rewriteVisitor;
    private final Map<Integer, ParameterConverter> parameterConverterMap = new HashMap<Integer, ParameterConverter>();
    private final Map<Integer, SqlParserPos> parameterPositionMap = new HashMap<Integer, SqlParserPos>();

    public HazelcastSqlValidator(SqlValidatorCatalogReader catalogReader, HazelcastTypeFactory typeFactory, SqlConformance conformance) {
        this(null, catalogReader, typeFactory, conformance);
    }

    public HazelcastSqlValidator(SqlOperatorTable extensionOperatorTable, SqlValidatorCatalogReader catalogReader, HazelcastTypeFactory typeFactory, SqlConformance conformance) {
        super(HazelcastSqlValidator.operatorTable(extensionOperatorTable), catalogReader, (RelDataTypeFactory)typeFactory, CONFIG.withSqlConformance(conformance));
        this.setTypeCoercion(new HazelcastTypeCoercion(this));
        this.rewriteVisitor = new HazelcastSqlOperatorTable.RewriteVisitor(this);
    }

    private static SqlOperatorTable operatorTable(SqlOperatorTable extensionOperatorTable) {
        ArrayList<SqlOperatorTable> operatorTables = new ArrayList<SqlOperatorTable>();
        if (extensionOperatorTable != null) {
            operatorTables.add(extensionOperatorTable);
        }
        operatorTables.add(HazelcastSqlOperatorTable.instance());
        return new ChainedSqlOperatorTable(operatorTables);
    }

    @Override
    protected void addToSelectList(List<SqlNode> list, Set<String> aliases, List<Map.Entry<String, RelDataType>> fieldList, SqlNode exp, SelectScope scope, boolean includeSystemVars) {
        if (this.isHiddenColumn(exp, scope)) {
            return;
        }
        super.addToSelectList(list, aliases, fieldList, exp, scope, includeSystemVars);
    }

    @Override
    public RelDataType deriveTypeImpl(SqlValidatorScope scope, SqlNode operand) {
        RelDataType literalType;
        if (operand.getKind() == SqlKind.LITERAL && (literalType = LiteralUtils.literalType(operand, (HazelcastTypeFactory)this.typeFactory)) != null) {
            return literalType;
        }
        return super.deriveTypeImpl(scope, operand);
    }

    @Override
    public void validateLiteral(SqlLiteral literal) {
    }

    @Override
    public void validateDynamicParam(SqlDynamicParam dynamicParam) {
        this.parameterPositionMap.put(dynamicParam.getIndex(), dynamicParam.getParserPosition());
    }

    @Override
    public void validateCall(SqlCall call, SqlValidatorScope scope) {
        this.deriveType(scope, call);
        super.validateCall(call, scope);
    }

    @Override
    public void validateQuery(SqlNode node, SqlValidatorScope scope, RelDataType targetRowType) {
        super.validateQuery(node, scope, targetRowType);
        if (node instanceof SqlSelect) {
            SqlNode fetch;
            SqlSelect select = (SqlSelect)node;
            SqlNode offset = select.getOffset();
            if (offset != null) {
                this.deriveType(scope, offset);
                this.validateNonNegativeValue(offset);
            }
            if ((fetch = select.getFetch()) != null) {
                this.deriveType(scope, fetch);
                this.validateNonNegativeValue(fetch);
            }
        }
    }

    private void validateNonNegativeValue(SqlNode sqlNode) {
        if (!(sqlNode instanceof SqlNumericLiteral)) {
            throw UnsupportedOperationVisitor.error(sqlNode, "FETCH/OFFSET must be a numeric literal");
        }
        Object value = ((SqlNumericLiteral)sqlNode).getValue();
        long value0 = ((Number)value).longValue();
        if (value0 < 0L) {
            throw UnsupportedOperationVisitor.error(sqlNode, "FETCH/OFFSET value cannot be negative: " + value0);
        }
    }

    @Override
    protected SqlNode performUnconditionalRewrites(SqlNode node, boolean underFrom) {
        SqlNode rewritten = super.performUnconditionalRewrites(node, underFrom);
        if (rewritten != null && rewritten.isA(SqlKind.TOP_LEVEL)) {
            rewritten.accept(this.rewriteVisitor);
        }
        return rewritten;
    }

    @Override
    public HazelcastTypeCoercion getTypeCoercion() {
        return (HazelcastTypeCoercion)super.getTypeCoercion();
    }

    public void setParameterConverter(int ordinal, ParameterConverter parameterConverter) {
        this.parameterConverterMap.put(ordinal, parameterConverter);
    }

    public ParameterConverter[] getParameterConverters(SqlNode node) {
        RelDataType rowType = this.getParameterRowType(node);
        ParameterConverter[] res = new ParameterConverter[rowType.getFieldCount()];
        for (int i = 0; i < res.length; ++i) {
            ParameterConverter converter = this.parameterConverterMap.get(i);
            if (converter == null) {
                converter = new StrictParameterConverter(i, this.parameterPositionMap.get(i), HazelcastTypeUtils.toHazelcastType(rowType.getFieldList().get(i).getType().getSqlTypeName()));
            }
            res[i] = converter;
        }
        return res;
    }

    private boolean isHiddenColumn(SqlNode node, SelectScope scope) {
        if (!(node instanceof SqlIdentifier)) {
            return false;
        }
        SqlIdentifier identifier = (SqlIdentifier)node;
        String fieldName = this.extractFieldName(identifier, scope);
        if (fieldName == null) {
            return false;
        }
        SqlValidatorTable table = scope.fullyQualify((SqlIdentifier)identifier).namespace.getTable();
        if (table == null) {
            return false;
        }
        HazelcastTable unwrappedTable = table.unwrap(HazelcastTable.class);
        if (unwrappedTable == null) {
            return false;
        }
        return unwrappedTable.isHidden(fieldName);
    }

    private String extractFieldName(SqlIdentifier identifier, SelectScope scope) {
        SqlCall call = this.makeNullaryCall(identifier);
        if (call != null) {
            return null;
        }
        SqlQualified qualified = scope.fullyQualify(identifier);
        ImmutableList<String> names = qualified.identifier.names;
        if (names.size() < 2) {
            return null;
        }
        return Util.last(names);
    }

    public boolean isInfiniteRows() {
        return false;
    }
}

