/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.literal;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCharStringLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNumericLiteral;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.literal.Literal;
import com.hazelcast.sql.impl.calcite.validate.literal.NumericLiteral;
import com.hazelcast.sql.impl.calcite.validate.literal.TypedLiteral;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;

public final class LiteralUtils {
    private LiteralUtils() {
    }

    public static Literal literal(SqlNode node) {
        if (node.getKind() != SqlKind.LITERAL) {
            return null;
        }
        SqlLiteral literal = (SqlLiteral)node;
        if (literal.getTypeName() == SqlTypeName.SYMBOL) {
            return null;
        }
        if (literal instanceof SqlNumericLiteral) {
            return NumericLiteral.create((SqlNumericLiteral)literal);
        }
        if (literal instanceof SqlCharStringLiteral) {
            return new TypedLiteral(literal, literal.getValueAs(String.class), SqlTypeName.VARCHAR);
        }
        return new TypedLiteral(literal, literal.getValue(), literal.getTypeName());
    }

    public static SqlTypeName literalTypeName(SqlNode node) {
        Literal literal = LiteralUtils.literal(node);
        return literal != null ? literal.getTypeName() : null;
    }

    public static RelDataType literalType(SqlNode node, HazelcastTypeFactory typeFactory) {
        Literal literal = LiteralUtils.literal(node);
        return literal != null ? literal.getType(typeFactory) : null;
    }
}

